//-------------------------------------------------------------------------
//
// File:		FileHandleC.h
// Desc:		File handle class.
// Author:		memon <memon@inside.org>
//
//-------------------------------------------------------------------------
//	Copyright (c) 2000 Moppi Productions. All Rights Reserved.
//  This file is part of Moppi Demopaja SDK. For conditions of 
//  distribution and use, see the accompanying license.txt file.
//  http://moppi.inside.org/demopaja/
//-------------------------------------------------------------------------

#ifndef __DEMOPAJA_FILEHANDLEC_H__
#define __DEMOPAJA_FILEHANDLEC_H__


namespace Import {
	class FileHandleC;
};


#include "PajaTypes.h"
#include "DataBlockI.h"
#include "EditableI.h"
#include "UndoC.h"
#include "ImportableI.h"


namespace Import {

	//! File handle class.
	/*!	The data loaded into Demopaja can be accessed via ImportableI interface.
		This file handle class is used to hold that interface. Even if files fail to
		load the file handle will always be there, so the file handle works as kind of
		smart reference to the file.
		
		This class is implemented by the system.
	*/
	class FileHandleC : public Edit::EditableI
	{
	public:
		//! Creates new file handle.
		static FileHandleC*			create_new();
		//! Creates new file handle.
		virtual Edit::DataBlockI*	create();
		//! Creates new file handle (used internally), see Edit::EditableI::create().
		virtual Edit::DataBlockI*	create( Edit::EditableI* pOriginal );
		//! Deep copy from a data block, see Edit::DataBlockI::copy().
		virtual void				copy( Edit::EditableI* pEditable );
		//! Shallow copy from a editable, see Edit::EditableI::restore().
		virtual void				restore( Edit::EditableI* pEditable );

		//! Returns the importable the file handle refers to.
		/*!	The return value can be NULL if the file is not
			present (failure in load, etc.). Always check the
			return value.
		*/
		virtual ImportableI*		get_importable();

		//! Sets the importable the file handle refers to. Used internally.
		virtual void				set_importable( ImportableI* pImportable );

		//! Get serialixation ID.
		/*!
		*/
		virtual PajaTypes::uint32	get_id();

		//! Set serialization ID.
		/*!	When the data is serialized out each file handle is given an ID which
			is used on to patch the file handles when the data
			is serialized in. The system sets this ID and it should not be changed.

			\see FileIO::LoadC::add_file_handle_patch
		*/
		virtual void				set_id( PajaTypes::uint32 i32ID );

		//! Increase reference count (used internally).
		virtual void				inc_reference_count();
		//! Reset reference count (used internally).
		virtual void				reset_reference_count();
		//! Returns reference count (used internally).
		virtual PajaTypes::int32	get_reference_count();

		// Serialize editable to a Demopaja output stream.
		virtual PajaTypes::uint32	save( FileIO::SaveC* pSave );
		// Serialize editable from a Demopaja input stream.
		virtual PajaTypes::uint32	load( FileIO::LoadC* pLoad );

	protected:
		//! Default constructor.
		FileHandleC();
		//! Default constructor with reference to the original.
		FileHandleC( Edit::EditableI* pOriginal );
		//! Default destructor.
		virtual ~FileHandleC();

	private:
		PajaTypes::int32	m_i32RefCount;
		ImportableI*		m_pImportable;
		PajaTypes::uint32	m_i32ID;
	};

};	// namespace

#endif