/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3.dds;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020\u0006H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u001a\u0010\u0017\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u001a\u0010\u001a\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\nR\u001a\u0010\u001d\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u001a\u0010)\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\u001a\u0010,\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010#\"\u0004\b.\u0010%R\u001a\u0010/\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010#\"\u0004\b1\u0010%R\u001a\u00102\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010#\"\u0004\b4\u0010%R\u001a\u00105\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010#\"\u0004\b6\u0010%R\u001a\u00107\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006?"}, d2={"Lorg/openrndr/internal/gl3/dds/DDSPixelFormat;", "", "header", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "dwABitMask", "", "getDwABitMask", "()I", "setDwABitMask", "(I)V", "dwBBitMask", "getDwBBitMask", "setDwBBitMask", "dwFlags", "getDwFlags", "setDwFlags", "dwFourCC", "getDwFourCC", "setDwFourCC", "dwGBitMask", "getDwGBitMask", "setDwGBitMask", "dwRBitMask", "getDwRBitMask", "setDwRBitMask", "dwRGBBitCount", "getDwRGBBitCount", "setDwRGBBitCount", "dwSize", "getDwSize", "setDwSize", "hasFlagAlpha", "", "getHasFlagAlpha", "()Z", "setHasFlagAlpha", "(Z)V", "hasFlagAlphaPixels", "getHasFlagAlphaPixels", "setHasFlagAlphaPixels", "hasFlagFourCC", "getHasFlagFourCC", "setHasFlagFourCC", "hasFlagLuminance", "getHasFlagLuminance", "setHasFlagLuminance", "hasFlagRgb", "getHasFlagRgb", "setHasFlagRgb", "hasFlagYuv", "getHasFlagYuv", "setHasFlagYuv", "isCompressed", "setCompressed", "sFourCC", "", "getSFourCC", "()Ljava/lang/String;", "setSFourCC", "(Ljava/lang/String;)V", "createFourCCString", "fourCC", "openrndr-gl3"})
public final class DDSPixelFormat {
    private int dwSize;
    private int dwFlags;
    private int dwFourCC;
    private int dwRGBBitCount;
    private int dwRBitMask;
    private int dwGBitMask;
    private int dwBBitMask;
    private int dwABitMask;
    @NotNull
    private String sFourCC;
    private boolean isCompressed;
    private boolean hasFlagAlphaPixels;
    private boolean hasFlagAlpha;
    private boolean hasFlagFourCC;
    private boolean hasFlagRgb;
    private boolean hasFlagYuv;
    private boolean hasFlagLuminance;

    public final int getDwSize() {
        return this.dwSize;
    }

    public final void setDwSize(int n) {
        this.dwSize = n;
    }

    public final int getDwFlags() {
        return this.dwFlags;
    }

    public final void setDwFlags(int n) {
        this.dwFlags = n;
    }

    public final int getDwFourCC() {
        return this.dwFourCC;
    }

    public final void setDwFourCC(int n) {
        this.dwFourCC = n;
    }

    public final int getDwRGBBitCount() {
        return this.dwRGBBitCount;
    }

    public final void setDwRGBBitCount(int n) {
        this.dwRGBBitCount = n;
    }

    public final int getDwRBitMask() {
        return this.dwRBitMask;
    }

    public final void setDwRBitMask(int n) {
        this.dwRBitMask = n;
    }

    public final int getDwGBitMask() {
        return this.dwGBitMask;
    }

    public final void setDwGBitMask(int n) {
        this.dwGBitMask = n;
    }

    public final int getDwBBitMask() {
        return this.dwBBitMask;
    }

    public final void setDwBBitMask(int n) {
        this.dwBBitMask = n;
    }

    public final int getDwABitMask() {
        return this.dwABitMask;
    }

    public final void setDwABitMask(int n) {
        this.dwABitMask = n;
    }

    @NotNull
    public final String getSFourCC() {
        return this.sFourCC;
    }

    public final void setSFourCC(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.sFourCC = string;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    public final void setCompressed(boolean bl) {
        this.isCompressed = bl;
    }

    public final boolean getHasFlagAlphaPixels() {
        return this.hasFlagAlphaPixels;
    }

    public final void setHasFlagAlphaPixels(boolean bl) {
        this.hasFlagAlphaPixels = bl;
    }

    public final boolean getHasFlagAlpha() {
        return this.hasFlagAlpha;
    }

    public final void setHasFlagAlpha(boolean bl) {
        this.hasFlagAlpha = bl;
    }

    public final boolean getHasFlagFourCC() {
        return this.hasFlagFourCC;
    }

    public final void setHasFlagFourCC(boolean bl) {
        this.hasFlagFourCC = bl;
    }

    public final boolean getHasFlagRgb() {
        return this.hasFlagRgb;
    }

    public final void setHasFlagRgb(boolean bl) {
        this.hasFlagRgb = bl;
    }

    public final boolean getHasFlagYuv() {
        return this.hasFlagYuv;
    }

    public final void setHasFlagYuv(boolean bl) {
        this.hasFlagYuv = bl;
    }

    public final boolean getHasFlagLuminance() {
        return this.hasFlagLuminance;
    }

    public final void setHasFlagLuminance(boolean bl) {
        this.hasFlagLuminance = bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String createFourCCString(int fourCC) {
        byte[] fourCCString = new byte[4];
        int n = 0;
        int n2 = fourCCString.length;
        while (n < n2) {
            void i;
            fourCCString[i] = (byte)(fourCC >> i * 8);
            ++i;
        }
        n = 0;
        return new String(fourCCString, Charsets.UTF_8);
    }

    public DDSPixelFormat(@NotNull ByteBuffer header) {
        Intrinsics.checkParameterIsNotNull(header, "header");
        this.dwSize = header.getInt();
        this.dwFlags = header.getInt();
        this.dwFourCC = header.getInt();
        this.dwRGBBitCount = header.getInt();
        this.dwRBitMask = header.getInt();
        this.dwGBitMask = header.getInt();
        this.dwBBitMask = header.getInt();
        this.dwABitMask = header.getInt();
        if (this.dwSize != 32) {
            throw (Throwable)new RuntimeException("size is not 32 bytes (is " + this.dwSize + " bytes)");
        }
        this.hasFlagAlphaPixels = (this.dwFlags & 1) == 1;
        this.hasFlagAlpha = (this.dwFlags & 2) == 2;
        this.hasFlagFourCC = (this.dwFlags & 4) == 4;
        this.hasFlagRgb = (this.dwFlags & 0x40) == 64;
        this.hasFlagYuv = (this.dwFlags & 0x200) == 512;
        this.hasFlagLuminance = (this.dwFlags & 0x20000) == 131072;
        String string = this.sFourCC = this.hasFlagFourCC ? this.createFourCCString(this.dwFourCC) : "";
        if (this.hasFlagFourCC) {
            this.isCompressed = true;
        } else if (this.hasFlagRgb) {
            this.isCompressed = false;
        }
    }
}

