/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eJ1\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000f0\u000eH\u0007\u00a2\u0006\u0002\b\u0012J$\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eJ+\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0007\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/internal/PerformanceLineDrawer;", "", "()V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "drawLineLoops", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "loops", "", "", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "drawLineLoops3d", "drawLineSegments", "segments", "drawLineSegments3d", "openrndr-core"})
public final class PerformanceLineDrawer {
    private final VertexBuffer vertices;
    private final ShadeStyleManager shaderManager;

    /*
     * WARNING - void declaration
     */
    @JvmName(name="drawLineSegments3d")
    public final void drawLineSegments3d(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Iterable<Vector3> segments) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        int vertexCount2 = 0;
        Iterable<Vector3> $this$forEachIndexed$iv = segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Vector3 item$iv : $this$forEachIndexed$iv) {
            void it;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Vector3 vector3 = item$iv;
            int index = n2;
            boolean bl2 = false;
            w.write((Vector3)it);
            w.write(index / 2);
            w.write(index % 2);
            int n3 = vertexCount2;
            vertexCount2 = n3 + 1;
        }
        this.vertices.getShadow().uploadElements(0, vertexCount2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.LINES, 0, vertexCount2);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineSegments(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Iterable<Vector2> segments) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        int vertexCount2 = 0;
        Iterable<Vector2> $this$forEachIndexed$iv = segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Vector2 item$iv : $this$forEachIndexed$iv) {
            void it;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Vector2 vector2 = item$iv;
            int index = n2;
            boolean bl2 = false;
            w.write((Vector2)it);
            w.write(0.0f);
            w.write(index / 2);
            w.write(index % 2);
            int n3 = vertexCount2;
            vertexCount2 = n3 + 1;
        }
        this.vertices.getShadow().uploadElements(0, vertexCount2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.LINES, 0, vertexCount2);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineLoops(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Iterable<? extends List<Vector2>> loops) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(loops, "loops");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        int vertexCount2 = 0;
        Iterable<? extends List<Vector2>> $this$forEachIndexed$iv = loops;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (List<Vector2> list : $this$forEachIndexed$iv) {
            void loop2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List<Vector2> list2 = list;
            int loopIndex = n2;
            boolean bl2 = false;
            int n3 = 0;
            int n4 = loop2.size() - 1;
            while (n3 < n4) {
                void i;
                w.write((Vector2)loop2.get((int)i));
                w.write(0.0f);
                w.write(loopIndex);
                w.write(1.0f);
                w.write((Vector2)loop2.get((int)(i + true)));
                w.write(0.0f);
                w.write(loopIndex);
                w.write(1.0f);
                vertexCount2 += 2;
                ++i;
            }
        }
        this.vertices.getShadow().uploadElements(0, vertexCount2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.LINES, 0, vertexCount2);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="drawLineLoops3d")
    public final void drawLineLoops3d(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Iterable<? extends List<Vector3>> loops) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(loops, "loops");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        int vertexCount2 = 0;
        Iterable<? extends List<Vector3>> $this$forEachIndexed$iv = loops;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (List<Vector3> list : $this$forEachIndexed$iv) {
            void loop2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List<Vector3> list2 = list;
            int loopIndex = n2;
            boolean bl2 = false;
            int n3 = 0;
            int n4 = loop2.size() - 1;
            while (n3 < n4) {
                void i;
                w.write((Vector3)loop2.get((int)i));
                w.write(loopIndex);
                w.write(1.0f);
                w.write((Vector3)loop2.get((int)(i + true)));
                w.write(loopIndex);
                w.write(1.0f);
                vertexCount2 += 2;
                ++i;
            }
        }
        this.vertices.getShadow().uploadElements(0, vertexCount2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.LINES, 0, vertexCount2);
        shader2.end();
    }

    public PerformanceLineDrawer() {
        VertexFormat vertexFormat2 = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        PerformanceLineDrawer performanceLineDrawer = this;
        boolean bl = false;
        boolean bl2 = false;
        VertexFormat $this$apply = vertexFormat2;
        boolean bl3 = false;
        $this$apply.position(3);
        VertexFormat.attribute$default($this$apply, "instance", VertexElementType.FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($this$apply, "vertexOffset", VertexElementType.FLOAT32, 0, 4, null);
        VertexFormat vertexFormat3 = vertexFormat2;
        performanceLineDrawer.vertices = companion.createDynamic(vertexFormat3, 0x100000);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).fastLineVertexShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "fastLineVertexShader";
            }

            public final String getSignature() {
                return "fastLineVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).fastLineFragmentShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "fastLineFragmentShader";
            }

            public final String getSignature() {
                return "fastLineFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
    }
}

