/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CommonPool;
import kotlinx.coroutines.DefaultExecutor;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.TimeSourceKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u001c\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0013\u001a\u00060\u001ej\u0002`\u001fH\u0016J\b\u0010 \u001a\u00020\u0006H\u0002J!\u0010!\u001a\u00020\u00102\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0005\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020\u0004H\u0016J\r\u0010\u000f\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkotlinx/coroutines/CommonPool;", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "()V", "DEFAULT_PARALLELISM_PROPERTY_NAME", "", "executor", "Ljava/util/concurrent/Executor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "parallelism", "", "getParallelism", "()I", "pool", "requestedParallelism", "usePrivatePool", "", "Try", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "close", "", "createPlainPool", "Ljava/util/concurrent/ExecutorService;", "createPool", "dispatch", "context", "Lkotlin/coroutines/CoroutineContext;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "getOrCreatePoolSync", "isGoodCommonPool", "fjpClass", "Ljava/lang/Class;", "isGoodCommonPool$kotlinx_coroutines_core", "restore", "restore$kotlinx_coroutines_core", "shutdown", "timeout", "", "shutdown$kotlinx_coroutines_core", "toString", "usePrivatePool$kotlinx_coroutines_core", "kotlinx-coroutines-core"})
public final class CommonPool
extends ExecutorCoroutineDispatcher {
    @NotNull
    public static final String DEFAULT_PARALLELISM_PROPERTY_NAME = "kotlinx.coroutines.default.parallelism";
    private static final int requestedParallelism;
    private static boolean usePrivatePool;
    private static volatile Executor pool;
    public static final CommonPool INSTANCE;

    @Override
    @NotNull
    public Executor getExecutor() {
        Executor executor2 = pool;
        if (executor2 == null) {
            executor2 = this.getOrCreatePoolSync();
        }
        return executor2;
    }

    private final int getParallelism() {
        Integer n = requestedParallelism;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        return n2 != null ? n2 : RangesKt.coerceAtLeast(Runtime.getRuntime().availableProcessors() - 1, 1);
    }

    private final <T> T Try(Function0<? extends T> block) {
        T t;
        int $i$f$Try = 0;
        try {
            t = block.invoke();
        }
        catch (Throwable e) {
            t = null;
        }
        return t;
    }

    private final ExecutorService createPool() {
        ExecutorService executorService;
        Class<?> $i$a$-Try-CommonPool$createPool$fjpClass$22;
        if (System.getSecurityManager() != null) {
            return this.createPlainPool();
        }
        AutoCloseable this_$iv = this;
        boolean $i$f$Try = false;
        try {
            boolean $i$a$-Try-CommonPool$createPool$fjpClass$22 = false;
            $i$a$-Try-CommonPool$createPool$fjpClass$22 = Class.forName("java.util.concurrent.ForkJoinPool");
        }
        catch (Throwable e$iv) {
            $i$a$-Try-CommonPool$createPool$fjpClass$22 = null;
        }
        Class<?> clazz = $i$a$-Try-CommonPool$createPool$fjpClass$22;
        if (clazz == null) {
            return this.createPlainPool();
        }
        Class<?> fjpClass = clazz;
        if (!usePrivatePool && requestedParallelism < 0) {
            AutoCloseable autoCloseable;
            this_$iv = this;
            $i$f$Try = false;
            try {
                boolean bl = false;
                Method method = fjpClass.getMethod("commonPool", new Class[0]);
                Object object = method != null ? method.invoke(null, new Object[0]) : null;
                if (!(object instanceof ExecutorService)) {
                    object = null;
                }
                executorService = (ExecutorService)object;
            }
            catch (Throwable e$iv) {
                executorService = null;
            }
            if ((autoCloseable = executorService) != null) {
                CommonPool it = this_$iv = autoCloseable;
                boolean bl = false;
                autoCloseable = INSTANCE.isGoodCommonPool$kotlinx_coroutines_core(fjpClass, (ExecutorService)((Object)it)) ? this_$iv : null;
                if (autoCloseable != null) {
                    it = this_$iv = autoCloseable;
                    boolean bl2 = false;
                    return it;
                }
            }
        }
        this_$iv = this;
        $i$f$Try = false;
        try {
            boolean bl = false;
            Object obj = fjpClass.getConstructor(Integer.TYPE).newInstance(INSTANCE.getParallelism());
            if (!(obj instanceof ExecutorService)) {
                obj = null;
            }
            executorService = (ExecutorService)obj;
        }
        catch (Throwable e$iv) {
            executorService = null;
        }
        ExecutorService executorService2 = executorService;
        if (executorService2 != null) {
            ExecutorService executorService3;
            ExecutorService it = executorService3 = executorService2;
            boolean bl = false;
            return it;
        }
        return this.createPlainPool();
    }

    public final boolean isGoodCommonPool$kotlinx_coroutines_core(@NotNull Class<?> fjpClass, @NotNull ExecutorService executor2) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(fjpClass, "fjpClass");
        Intrinsics.checkParameterIsNotNull(executor2, "executor");
        executor2.submit(isGoodCommonPool.1.INSTANCE);
        CommonPool this_$iv = this;
        boolean $i$f$Try = false;
        try {
            boolean bl = false;
            Object object = fjpClass.getMethod("getPoolSize", new Class[0]).invoke((Object)executor2, new Object[0]);
            if (!(object instanceof Integer)) {
                object = null;
            }
            n = (Integer)object;
        }
        catch (Throwable e$iv) {
            n = null;
        }
        Integer n2 = n;
        if (n2 == null) {
            return false;
        }
        int actual = n2;
        return actual >= 1;
    }

    private final ExecutorService createPlainPool() {
        AtomicInteger threadId = new AtomicInteger();
        ExecutorService executorService = Executors.newFixedThreadPool(this.getParallelism(), new ThreadFactory(threadId){
            final /* synthetic */ AtomicInteger $threadId;

            @NotNull
            public final Thread newThread(Runnable it) {
                Thread thread2;
                Thread $receiver = thread2 = new Thread(it, "CommonPool-worker-" + this.$threadId.incrementAndGet());
                boolean bl = false;
                $receiver.setDaemon(true);
                return thread2;
            }
            {
                this.$threadId = atomicInteger;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(executorService, "Executors.newFixedThread\u2026Daemon = true }\n        }");
        return executorService;
    }

    private final synchronized Executor getOrCreatePoolSync() {
        Executor executor2 = pool;
        if (executor2 == null) {
            ExecutorService executorService;
            ExecutorService it = executorService = this.createPool();
            boolean bl = false;
            pool = it;
            executor2 = executorService;
        }
        return executor2;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        try {
            Executor executor2 = pool;
            if (executor2 == null) {
                executor2 = this.getOrCreatePoolSync();
            }
            executor2.execute(TimeSourceKt.getTimeSource().wrapTask(block));
        }
        catch (RejectedExecutionException e) {
            TimeSourceKt.getTimeSource().unTrackTask();
            DefaultExecutor.INSTANCE.enqueue(block);
        }
    }

    public final synchronized void usePrivatePool$kotlinx_coroutines_core() {
        this.shutdown$kotlinx_coroutines_core(0L);
        usePrivatePool = true;
        pool = null;
    }

    public final synchronized void shutdown$kotlinx_coroutines_core(long timeout) {
        Executor executor2 = pool;
        if (!(executor2 instanceof ExecutorService)) {
            executor2 = null;
        }
        ExecutorService executorService = (ExecutorService)executor2;
        if (executorService != null) {
            ExecutorService executorService2;
            ExecutorService $receiver = executorService2 = executorService;
            boolean bl = false;
            $receiver.shutdown();
            if (timeout > 0L) {
                $receiver.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            List<Runnable> list = $receiver.shutdownNow();
            Intrinsics.checkExpressionValueIsNotNull(list, "shutdownNow()");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Runnable it = (Runnable)element$iv;
                boolean bl2 = false;
                Runnable runnable = it;
                Intrinsics.checkExpressionValueIsNotNull(runnable, "it");
                DefaultExecutor.INSTANCE.enqueue(runnable);
            }
        }
        pool = shutdown.2.INSTANCE;
    }

    public final synchronized void restore$kotlinx_coroutines_core() {
        this.shutdown$kotlinx_coroutines_core(0L);
        usePrivatePool = false;
        pool = null;
    }

    @Override
    @NotNull
    public String toString() {
        return "CommonPool";
    }

    @Override
    public void close() {
        String string = "Close cannot be invoked on CommonPool";
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private CommonPool() {
    }

    static {
        int n;
        String string;
        CommonPool commonPool;
        INSTANCE = commonPool = new CommonPool();
        boolean bl = false;
        CommonPool this_$iv = INSTANCE;
        boolean $i$f$Try = false;
        try {
            boolean bl2 = false;
            string = System.getProperty(DEFAULT_PARALLELISM_PROPERTY_NAME);
        }
        catch (Throwable e$iv) {
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            n = -1;
        } else {
            String property = string2;
            Integer parallelism = StringsKt.toIntOrNull(property);
            if (parallelism == null || parallelism < 1) {
                String string3 = "Expected positive number in kotlinx.coroutines.default.parallelism, but has " + property;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            n = parallelism;
        }
        requestedParallelism = n;
    }
}

