/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassDescriptor annotationClass = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, proto.getId()));
        Map<Name, ConstantValue<Object>> arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "annotationClass.constructors");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$associateByTo$iv$iv;
                List<ValueParameterDescriptor> list = constructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list, "constructor.valueParameters");
                Iterable $this$associateBy$iv = list;
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                    Name name = v2.getName();
                    map2.put(name, element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list2 = proto.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list2, "proto.argumentList");
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable capacity$iv22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ProtoBuf.Annotation.Argument it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    boolean bl2 = false;
                    ProtoBuf.Annotation.Argument argument = it;
                    Intrinsics.checkExpressionValueIsNotNull(argument, "it");
                    if (this.resolveArgument(argument, parameterByName, nameResolver) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Pair<Name, ConstantValue<?>> it$iv$iv = pair;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments2 = MapsKt.toMap((List)destination$iv$iv2);
            }
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(NameResolverUtilKt.getName(nameResolver, proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver, proto.getNameId());
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameter.type");
        ProtoBuf.Annotation.Argument.Value value2 = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull(value2, "proto.value");
        return new Pair(name, this.resolveValue(kotlinType, value2, nameResolver));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        v0 = Flags.IS_UNSIGNED.get(value.getFlags());
        Intrinsics.checkExpressionValueIsNotNull(v0, "Flags.IS_UNSIGNED.get(value.flags)");
        isUnsigned = v0;
        v1 = value.getType();
        if (v1 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
            case 1: {
                var7_5 = (byte)value.getIntValue();
                this_$iv = this;
                $i$f$letIf = false;
                if (isUnsigned) {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$1 = false;
                    v2 /* !! */  = new UByteValue((byte)p1);
                } else {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$2 = false;
                    v2 /* !! */  = new ByteValue((byte)p1);
                }
                v3 = v2 /* !! */ ;
                break;
            }
            case 2: {
                v3 = new CharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                $this$letIf$iv = (short)value.getIntValue();
                this_$iv = this;
                $i$f$letIf = false;
                if (isUnsigned) {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$3 = false;
                    v4 /* !! */  = new UShortValue(p1);
                } else {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$4 = false;
                    v4 /* !! */  = new ShortValue(p1);
                }
                v3 = v4 /* !! */ ;
                break;
            }
            case 4: {
                $this$letIf$iv = (int)value.getIntValue();
                this_$iv = this;
                $i$f$letIf = false;
                if (isUnsigned) {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$5 = false;
                    v5 /* !! */  = new UIntValue(p1);
                } else {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$6 = false;
                    v5 /* !! */  = new IntValue(p1);
                }
                v3 = v5 /* !! */ ;
                break;
            }
            case 5: {
                $this$letIf$iv = value.getIntValue();
                this_$iv = this;
                $i$f$letIf = false;
                if (isUnsigned) {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$7 = false;
                    v6 /* !! */  = new ULongValue(p1);
                } else {
                    p1 = $this$letIf$iv;
                    $i$a$-unknown-AnnotationDeserializer$resolveValue$result$8 = false;
                    v6 /* !! */  = new LongValue(p1);
                }
                v3 = v6 /* !! */ ;
                break;
            }
            case 6: {
                v3 = new FloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v3 = new DoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v3 = new BooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v3 = new StringValue(nameResolver.getString(value.getStringValue()));
                break;
            }
            case 10: {
                v3 = new KClassValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()), value.getArrayDimensionCount());
                break;
            }
            case 11: {
                v3 = new EnumValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()), NameResolverUtilKt.getName(nameResolver, value.getEnumValueId()));
                break;
            }
            case 12: {
                v7 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull(v7, "value.annotation");
                v3 = new AnnotationValue(this.deserializeAnnotation(v7, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                v8 = arrayElements = value.getArrayElementList();
                Intrinsics.checkExpressionValueIsNotNull(v8, "arrayElements");
                p1 = v8;
                $i$a$-unknown-AnnotationDeserializer$resolveValue$result$6 = false;
                if (p1.isEmpty() == false) {
                    v9 = CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull(v9, "arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v9, nameResolver);
                    v10 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v10 != null) {
                        v11 = v10;
                    } else {
                        v12 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                        Intrinsics.checkExpressionValueIsNotNull(v12, "builtIns.getArrayType(Va\u2026RIANT, actualElementType)");
                        v11 = v12;
                    }
                } else if (expectedIsArray) {
                    v11 = expectedType;
                } else {
                    v13 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    Intrinsics.checkExpressionValueIsNotNull(v13, "builtIns.getArrayType(Va\u2026ARIANT, builtIns.anyType)");
                    v11 = v13;
                }
                actualArrayType = v11;
                v14 = this.getBuiltIns().getArrayElementType(expectedIsArray != false ? expectedType : actualArrayType);
                Intrinsics.checkExpressionValueIsNotNull(v14, "builtIns.getArrayElement\u2026ype else actualArrayType)");
                expectedElementType = v14;
                $i$a$-unknown-AnnotationDeserializer$resolveValue$result$6 = arrayElements;
                var20_40 = ConstantValueFactory.INSTANCE;
                $i$f$map = false;
                var13_41 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_46 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var21_48 = destination$iv$iv;
                    $i$a$-map-AnnotationDeserializer$resolveValue$result$9 = false;
                    v15 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v15, "it");
                    var22_49 = this.resolveValue(expectedElementType, (ProtoBuf.Annotation.Argument.Value)v15, nameResolver);
                    var21_48.add(var22_49);
                }
                var21_48 = (List)destination$iv$iv;
                v3 = var20_40.createArrayValue((List<? extends ConstantValue<?>>)var21_48, actualArrayType);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var6_16 = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ')';
                var7_10 = false;
                throw (Throwable)new IllegalStateException(var6_16.toString());
            }
        }
        result = v3;
        return TypeUtilsKt.isSubtypeOf(result.getType(this.module), expectedType) != false ? result : (ConstantValue)ErrorValue.Companion.create("Unexpected argument value: type " + result.getType(this.module) + " is not a subtype of " + expectedType + " (value.type = " + value.getType() + ')');
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SimpleType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value2, NameResolver nameResolver) {
        KotlinBuiltIns kotlinBuiltIns = this.getBuiltIns();
        boolean bl = false;
        boolean bl2 = false;
        KotlinBuiltIns $this$with = kotlinBuiltIns;
        boolean bl3 = false;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value2.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    SimpleType simpleType2 = $this$with.getByteType();
                    SimpleType simpleType3 = simpleType2;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "byteType");
                    return simpleType3;
                }
                case 2: {
                    SimpleType simpleType4 = $this$with.getCharType();
                    SimpleType simpleType3 = simpleType4;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType4, "charType");
                    return simpleType3;
                }
                case 3: {
                    SimpleType simpleType5 = $this$with.getShortType();
                    SimpleType simpleType3 = simpleType5;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType5, "shortType");
                    return simpleType3;
                }
                case 4: {
                    SimpleType simpleType6 = $this$with.getIntType();
                    SimpleType simpleType3 = simpleType6;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType6, "intType");
                    return simpleType3;
                }
                case 5: {
                    SimpleType simpleType7 = $this$with.getLongType();
                    SimpleType simpleType3 = simpleType7;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType7, "longType");
                    return simpleType3;
                }
                case 6: {
                    SimpleType simpleType8 = $this$with.getFloatType();
                    SimpleType simpleType3 = simpleType8;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType8, "floatType");
                    return simpleType3;
                }
                case 7: {
                    SimpleType simpleType9 = $this$with.getDoubleType();
                    SimpleType simpleType3 = simpleType9;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType9, "doubleType");
                    return simpleType3;
                }
                case 8: {
                    SimpleType simpleType10 = $this$with.getBooleanType();
                    SimpleType simpleType3 = simpleType10;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType10, "booleanType");
                    return simpleType3;
                }
                case 9: {
                    SimpleType simpleType11 = $this$with.getStringType();
                    SimpleType simpleType3 = simpleType11;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType11, "stringType");
                    return simpleType3;
                }
                case 10: {
                    String string = "Arrays of class literals are not supported yet";
                    boolean bl4 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                case 11: {
                    SimpleType simpleType12 = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, value2.getClassId())).getDefaultType();
                    SimpleType simpleType3 = simpleType12;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType12, "resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return simpleType3;
                }
                case 12: {
                    ProtoBuf.Annotation annotation = value2.getAnnotation();
                    Intrinsics.checkExpressionValueIsNotNull(annotation, "value.annotation");
                    SimpleType simpleType13 = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, annotation.getId())).getDefaultType();
                    SimpleType simpleType3 = simpleType13;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType13, "resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return simpleType3;
                }
                case 13: {
                    String string = "Array of arrays is impossible";
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        String string = "Unknown type: " + value2.getType();
        boolean bl6 = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(notFoundClasses, "notFoundClasses");
        this.module = module;
        this.notFoundClasses = notFoundClasses;
    }
}

