/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.utils.wav;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jouvieje.bass.utils.FileIOUtils;
import jouvieje.bass.utils.wav.DataChunk;
import jouvieje.bass.utils.wav.FmtChunk;
import jouvieje.bass.utils.wav.WavHeader;

public class Wav {
    private final WavHeader wavHeader;
    private final FmtChunk fmtChunk;
    private final DataChunk dataChunk;

    public Wav(WavHeader wavHeader, FmtChunk fmtChunk, DataChunk dataChunk) {
        this.wavHeader = wavHeader;
        this.fmtChunk = fmtChunk;
        this.dataChunk = dataChunk;
    }

    public WavHeader getWavHeader() {
        return this.wavHeader;
    }

    public FmtChunk getFmtChunk() {
        return this.fmtChunk;
    }

    public DataChunk getDataChunk() {
        return this.dataChunk;
    }

    public void write(RandomAccessFile raf) throws IOException {
        FileIOUtils io = new FileIOUtils();
        this.wavHeader.write(raf, io);
        this.fmtChunk.write(raf, io);
        this.dataChunk.write(raf, io);
    }

    public void put(ByteBuffer buffer) {
        this.wavHeader.put(buffer);
        this.fmtChunk.put(buffer);
        this.dataChunk.put(buffer);
    }
}

