/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.DirectedGraph;
import io.lacuna.bifurcan.Graphs;
import io.lacuna.bifurcan.IEdge;
import io.lacuna.bifurcan.IGraph;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.LinearSet;
import io.lacuna.bifurcan.Set;
import io.lacuna.bifurcan.Sets;
import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class DirectedAcyclicGraph<V, E>
implements IGraph<V, E> {
    private DirectedGraph<V, E> graph;
    private Set<V> top;
    private Set<V> bottom;

    private DirectedAcyclicGraph(DirectedGraph<V, E> graph, Set<V> top, Set<V> bottom) {
        this.graph = graph;
        this.top = top;
        this.bottom = bottom;
    }

    public DirectedAcyclicGraph() {
        this(new DirectedGraph(), new Set(), new Set());
    }

    public static <V, E> DirectedAcyclicGraph<V, E> from(DirectedGraph<V, E> graph) {
        if (Graphs.stronglyConnectedComponents(graph, false).size() > 0L) {
            throw new CycleException("graph contains a cycle");
        }
        return new DirectedAcyclicGraph<V, E>(graph, graph.vertices().stream().filter(v -> ((Set)graph.in(v)).size() == 0L).collect(Sets.collector()), graph.vertices().stream().filter(v -> ((Set)graph.out(v)).size() == 0L).collect(Sets.collector()));
    }

    public Set<V> top() {
        return this.top;
    }

    public Set<V> bottom() {
        return this.bottom;
    }

    @Override
    public Set<V> vertices() {
        return this.graph.vertices();
    }

    @Override
    public Iterable<IEdge<V, E>> edges() {
        return this.graph.edges();
    }

    @Override
    public E edge(V src, V dst) {
        return this.graph.edge(src, dst);
    }

    @Override
    public Set<V> in(V vertex) {
        return this.graph.in((Object)vertex);
    }

    @Override
    public Set<V> out(V vertex) {
        return this.graph.out((Object)vertex);
    }

    @Override
    public DirectedAcyclicGraph<V, E> link(V from, V to, E edge, BinaryOperator<E> merge) {
        if (((Set)this.vertices()).contains(from) && ((Set)this.vertices()).contains(to) && this.createsCycle(from, to)) {
            throw new CycleException("new edge creates a cycle");
        }
        IGraph graphPrime = this.graph.link((Object)from, (Object)to, (Object)edge, (BinaryOperator)merge);
        ISet topPrime = this.top.remove((Object)to);
        ISet bottomPrime = this.bottom.remove((Object)from);
        if (this.isLinear()) {
            this.graph = graphPrime;
            this.top = topPrime;
            this.bottom = bottomPrime;
            return this;
        }
        return new DirectedAcyclicGraph<V, E>(graphPrime, topPrime, bottomPrime);
    }

    @Override
    public DirectedAcyclicGraph<V, E> unlink(V from, V to) {
        Set<V> bottomPrime;
        IGraph graphPrime = this.graph.unlink((Object)from, (Object)to);
        Set<V> topPrime = ((Set)this.graph.in((Object)to)).size() == 1L ? this.top.add((Object)to) : this.top;
        ISet<V> iSet = bottomPrime = ((Set)this.graph.out((Object)from)).size() == 1L ? this.bottom.add((Object)from) : this.bottom;
        if (this.isLinear() || this.graph == graphPrime) {
            this.graph = graphPrime;
            this.top = topPrime;
            this.bottom = bottomPrime;
            return this;
        }
        return new DirectedAcyclicGraph<V, E>(graphPrime, topPrime, bottomPrime);
    }

    @Override
    public DirectedAcyclicGraph<V, E> merge(IGraph<V, E> graph, BinaryOperator<E> merge) {
        return DirectedAcyclicGraph.from(this.graph.merge((IGraph)graph, (BinaryOperator)merge));
    }

    @Override
    public DirectedAcyclicGraph<V, E> select(ISet<V> vertices) {
        return new DirectedAcyclicGraph<V, E>(this.graph.select((ISet)vertices), this.top.intersection((ISet)vertices), this.bottom.intersection((ISet)vertices));
    }

    @Override
    public DirectedAcyclicGraph<V, E> add(V vertex) {
        if (((Set)this.graph.vertices()).contains(vertex)) {
            return this;
        }
        IGraph graphPrime = this.graph.add((Object)vertex);
        ISet topPrime = this.top.add((Object)vertex);
        ISet bottomPrime = this.bottom.add((Object)vertex);
        if (this.isLinear()) {
            this.graph = graphPrime;
            this.top = topPrime;
            this.bottom = bottomPrime;
            return this;
        }
        return new DirectedAcyclicGraph<V, E>(graphPrime, topPrime, bottomPrime);
    }

    @Override
    public DirectedAcyclicGraph<V, E> remove(V vertex) {
        if (((Set)this.graph.vertices()).contains(vertex)) {
            ISet topPrime = this.top.union((ISet)this.graph.out((Object)vertex).stream().filter(v -> ((Set)this.graph.in(v)).size() == 1L).collect(Sets.collector()));
            ISet bottomPrime = this.bottom.union((ISet)this.graph.in((Object)vertex).stream().filter(v -> ((Set)this.graph.out(v)).size() == 1L).collect(Sets.collector()));
            IGraph graphPrime = this.graph.remove((Object)vertex);
            if (this.isLinear()) {
                this.graph = graphPrime;
                this.top = topPrime;
                this.bottom = bottomPrime;
                return this;
            }
            return new DirectedAcyclicGraph<V, E>(graphPrime, topPrime, bottomPrime);
        }
        return this;
    }

    @Override
    public DirectedAcyclicGraph<V, E> forked() {
        return this.graph.isLinear() ? new DirectedAcyclicGraph<V, E>(this.graph.forked(), this.top.forked(), this.bottom.forked()) : this;
    }

    @Override
    public DirectedAcyclicGraph<V, E> linear() {
        return this.graph.isLinear() ? this : new DirectedAcyclicGraph<V, E>(this.graph.linear(), this.top.linear(), this.bottom.linear());
    }

    @Override
    public boolean isLinear() {
        return this.graph.isLinear();
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public <U> DirectedAcyclicGraph<V, U> mapEdges(Function<IEdge<V, E>, U> f) {
        return new DirectedAcyclicGraph<V, E>(this.graph.mapEdges((Function)f), this.top, this.bottom);
    }

    @Override
    public DirectedAcyclicGraph<V, E> transpose() {
        return new DirectedAcyclicGraph<V, E>(this.graph.transpose(), this.bottom, this.top);
    }

    @Override
    public ToIntFunction<V> vertexHash() {
        return this.graph.vertexHash();
    }

    @Override
    public BiPredicate<V, V> vertexEquality() {
        return this.graph.vertexEquality();
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public boolean equals(Object obj) {
        return this.graph.equals(obj);
    }

    public String toString() {
        return this.graph.toString();
    }

    @Override
    public DirectedAcyclicGraph<V, E> clone() {
        return new DirectedAcyclicGraph<V, E>(this.graph.clone(), this.bottom.clone(), this.top.clone());
    }

    private boolean createsCycle(V from, V to) {
        Iterator<Object> upstreamIterator = Graphs.bfsVertices(LinearList.of(from), object -> this.in(object));
        Iterator<Object> downstreamIterator = Graphs.bfsVertices(LinearList.of(to), object -> this.out(object));
        if (!upstreamIterator.hasNext() || !downstreamIterator.hasNext()) {
            return false;
        }
        LinearSet<Object> upstream = new LinearSet<Object>(this.vertexHash(), this.vertexEquality());
        LinearSet<Object> downstream = new LinearSet<Object>(this.vertexHash(), this.vertexEquality());
        while (upstreamIterator.hasNext() && downstreamIterator.hasNext()) {
            Object a2 = upstreamIterator.next();
            if (downstream.contains(a2)) {
                return true;
            }
            upstream.add(a2);
            Object b = downstreamIterator.next();
            if (upstream.contains(b)) {
                return true;
            }
            downstream.add(b);
        }
        return false;
    }

    public static class CycleException
    extends IllegalArgumentException {
        public CycleException(String message) {
            super(message);
        }
    }
}

