/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils.regions;

import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Interval;
import io.lacuna.artifex.Region2;
import io.lacuna.artifex.Ring2;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.utils.Combinatorics;
import io.lacuna.artifex.utils.regions.Split;
import io.lacuna.bifurcan.DirectedGraph;
import io.lacuna.bifurcan.Graphs;
import io.lacuna.bifurcan.IEdge;
import io.lacuna.bifurcan.IGraph;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.LinearSet;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Sets;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;

public class Clip {
    public static final BinaryOperator<Arc> SHORTEST_ARC = (x, y) -> x.length() < y.length() ? x : y;
    private static final ISet<Vec2> VERTICES = new LinearSet<Vec2>();
    private static final int MAX_REPAIR_ATTEMPTS = 10;

    private static void describe(String prefix, IList<Vec2> ... arcs) {
        for (IList<Vec2> arc : arcs) {
            arc.forEach(VERTICES::add);
            System.out.print(prefix + " ");
            arc.forEach(v -> System.out.print(VERTICES.indexOf((Vec2)v) + " "));
            System.out.println();
        }
    }

    private static double area(IList<Arc> arcs) {
        return Math.abs(arcs.stream().mapToDouble(Arc::signedArea).sum());
    }

    private static double length(IList<Arc> arcs) {
        return Math.abs(arcs.stream().mapToDouble(Arc::length).sum());
    }

    private static Ring2 ring(IList<Arc> arcs) {
        LinearList<Curve2> acc = new LinearList<Curve2>();
        arcs.forEach(arc -> arc.forEach(acc::addLast));
        return new Ring2(acc);
    }

    private static Arc arc(Curve2 ... cs) {
        Arc result2 = new Arc();
        for (Curve2 c2 : cs) {
            result2.addLast(c2);
        }
        return result2;
    }

    private static <U, V> IList<V> edges(IList<U> vertices, BiFunction<U, U, V> edge) {
        LinearList<V> result2 = new LinearList<V>();
        int i = 0;
        while ((long)i < vertices.size() - 1L) {
            result2.addLast(edge.apply(vertices.nth(i), vertices.nth(i + 1)));
            ++i;
        }
        return result2;
    }

    private static boolean isTop(Curve2 c2) {
        if (c2 == null) {
            return false;
        }
        double delta = c2.end().x - c2.start().x;
        if (delta == 0.0) {
            return c2.end().y > c2.start().y;
        }
        return delta < 0.0;
    }

    private static Type classify(Region2 region, Arc arc) {
        Ring2.Result result2 = region.test(arc.position(0.36787944117144233));
        if (!result2.inside) {
            return Type.OUTSIDE;
        }
        if (result2.curve == null) {
            return Type.INSIDE;
        }
        return Clip.isTop((Curve2)arc.first()) == Clip.isTop(result2.curve) ? Type.SAME_EDGE : Type.DIFF_EDGE;
    }

    private static IList<Arc> partition(Region2 region, ISet<Vec2> vertices) {
        LinearList<Arc> result2 = new LinearList<Arc>();
        for (Ring2 r : region.rings) {
            int i;
            int offset2;
            Curve2[] cs = r.curves;
            for (offset2 = 0; offset2 < cs.length && !vertices.contains(cs[offset2].start()); ++offset2) {
            }
            if (offset2 == cs.length) {
                result2.addLast(Clip.arc(cs));
                continue;
            }
            Arc acc = new Arc();
            for (i = offset2; i < cs.length; ++i) {
                Curve2 c2 = cs[i];
                if (vertices.contains(c2.start())) {
                    if (acc.size() > 0L) {
                        result2.addLast(acc);
                    }
                    acc = Clip.arc(c2);
                    continue;
                }
                acc.addLast(c2);
            }
            for (i = 0; i < offset2; ++i) {
                acc.addLast(cs[i]);
            }
            if (acc.size() <= 0L) continue;
            result2.addLast(acc);
        }
        return result2;
    }

    private static IList<IList<Arc>> greedyPairing(IGraph<Vec2, Arc> graph, IList<Vec2> out, ISet<Vec2> in) {
        LinearList<IList<Arc>> result2 = new LinearList<IList<Arc>>();
        ISet<Vec2> currIn = in.clone();
        for (Vec2 v : out) {
            if (currIn.size() == 0L) break;
            IList path = Graphs.shortestPath(graph, v, currIn::contains, e -> ((Arc)e.value()).length()).orElse(null);
            if (path == null) {
                return null;
            }
            currIn.remove((Vec2)path.last());
            result2.addLast(Clip.edges(path, graph::edge));
        }
        return result2;
    }

    private static IList<IList<Arc>> repairGraph(IGraph<Vec2, ISet<Arc>> graph, Iterable<Arc> unused) {
        Object search = new DirectedGraph().linear();
        for (Arc arc : unused) {
            search.link(arc.head(), arc.tail(), arc, SHORTEST_ARC);
        }
        for (IEdge iEdge : graph.edges()) {
            Arc arc = ((ISet)iEdge.value()).stream().min(Comparator.comparingDouble(Arc::length)).get();
            search.link(arc.tail(), arc.head(), arc, SHORTEST_ARC);
        }
        ISet in = graph.vertices().stream().filter(v -> graph.in((Vec2)v).size() == 0L).collect(Sets.linearCollector());
        ISet iSet = graph.vertices().stream().filter(v -> graph.out((Vec2)v).size() == 0L).collect(Sets.linearCollector());
        ISet<Vec2> currIn = in.clone();
        ISet<Vec2> currOut = iSet.clone();
        LinearSet<IList<Arc>> result2 = new LinearSet<IList<Arc>>();
        while (currIn.size() > 0L && currOut.size() > 0L) {
            IList path2 = Graphs.shortestPath(search, currOut, in::contains, e -> ((Arc)e.value()).length()).orElse(null);
            if (path2 == null || !currIn.contains((Vec2)path2.last())) break;
            currOut.remove((Vec2)path2.first());
            currIn.remove((Vec2)path2.last());
            result2.add(Clip.edges(path2, ((IGraph)search)::edge));
        }
        if (currIn.size() == 0L || currOut.size() == 0L) {
            return result2.elements();
        }
        return Combinatorics.permutations(iSet.elements()).stream().map(arg_0 -> Clip.lambda$repairGraph$7((IGraph)search, in, arg_0)).filter(Objects::nonNull).min(Comparator.comparingDouble(path -> path.stream().mapToDouble(Clip::length).sum())).orElseGet(LinearList::new);
    }

    public static Region2 operation(Region2 ra, Region2 rb, Operation operation, Predicate<Type> aPredicate, Predicate<Type> bPredicate) {
        Split.Result split2 = Split.split(ra, rb);
        Region2 a2 = split2.a;
        Region2 b = split2.b;
        IList<Arc> pa = Clip.partition(a2, split2.splits);
        IList pb = Clip.partition(b, split2.splits);
        if (operation == Operation.DIFFERENCE) {
            pb = pb.stream().map(Arc::reverse).collect(Lists.linearCollector());
        }
        ISet<Arc> arcs = new LinearSet();
        pa.stream().filter(arc -> aPredicate.test(Clip.classify(b, arc))).forEach(arcs::add);
        pb.stream().filter(arc -> bPredicate.test(Clip.classify(a2, arc))).forEach(arcs::add);
        LinearList<Ring2> result2 = new LinearList<Ring2>();
        LinearSet consumed = new LinearSet();
        for (int i = 0; i < 10; ++i) {
            Object graph = new DirectedGraph().linear();
            arcs.forEach(arg_0 -> Clip.lambda$operation$11((IGraph)graph, arg_0));
            if (i > 0) {
                for (IList<Arc> path : Clip.repairGraph((IGraph<Vec2, ISet<Arc>>)graph, ((LinearSet)LinearSet.from(pa.concat(pb)).difference((ISet)arcs)).difference((ISet)consumed))) {
                    for (Arc arc2 : path) {
                        if (arcs.contains(arc2)) {
                            graph.unlink(arc2.head(), arc2.tail());
                            arcs.remove(arc2);
                            continue;
                        }
                        graph.link(arc2.head(), arc2.tail(), LinearSet.of(arc2));
                        arcs.add(arc2);
                    }
                }
            }
            IList cycles = Graphs.cycles(graph).stream().map(arg_0 -> Clip.lambda$operation$13((IGraph)graph, arg_0)).map(Combinatorics::combinations).flatMap(IList::stream).sorted(Comparator.comparingDouble(Clip::area).reversed()).collect(Lists.linearCollector());
            for (IList cycle : cycles) {
                if (cycle.stream().anyMatch(consumed::contains)) continue;
                cycle.forEach(consumed::add);
                result2.addLast(Clip.ring(cycle));
            }
            if ((arcs = arcs.difference(consumed)).size() == 0L) break;
        }
        assert (arcs.size() == 0L);
        return new Region2(result2);
    }

    public static Region2 union(Region2 a2, Region2 b) {
        return Clip.operation(a2, b, Operation.UNION, t -> t == Type.OUTSIDE || t == Type.SAME_EDGE, t -> t == Type.OUTSIDE);
    }

    public static Region2 intersection(Region2 a2, Region2 b) {
        return Clip.operation(a2, b, Operation.INTERSECTION, t -> t == Type.INSIDE || t == Type.SAME_EDGE, t -> t == Type.INSIDE);
    }

    public static Region2 difference(Region2 a2, Region2 b) {
        return Clip.operation(a2, b, Operation.DIFFERENCE, t -> t == Type.OUTSIDE || t == Type.DIFF_EDGE, t -> t == Type.INSIDE);
    }

    private static /* synthetic */ IList lambda$operation$13(IGraph graph, List cycle) {
        return Clip.edges(cycle, (x, y) -> ((ISet)graph.edge(x, y)).elements());
    }

    private static /* synthetic */ void lambda$operation$11(IGraph graph, Arc arc) {
        graph.link(arc.head(), arc.tail(), LinearSet.of(arc), ISet::union);
    }

    private static /* synthetic */ IList lambda$repairGraph$7(IGraph search, ISet in, IList vs) {
        return Clip.greedyPairing(search, vs, in);
    }

    private static enum Type {
        OUTSIDE,
        INSIDE,
        SAME_EDGE,
        DIFF_EDGE;

    }

    private static enum Operation {
        UNION,
        INTERSECTION,
        DIFFERENCE;

    }

    private static final class Arc
    extends LinearList<Curve2> {
        private double length = Double.NaN;
        private double area = Double.NaN;

        private Arc() {
        }

        double length() {
            if (Double.isNaN(this.length)) {
                this.length = this.stream().mapToDouble(c2 -> c2.end().sub(c2.start()).length()).sum();
            }
            return this.length;
        }

        double signedArea() {
            if (Double.isNaN(this.area)) {
                this.area = this.stream().mapToDouble(Curve2::signedArea).sum();
            }
            return this.area;
        }

        Vec2 head() {
            return ((Curve2)this.first()).start();
        }

        Vec2 tail() {
            return ((Curve2)this.last()).end();
        }

        Vec2 position(double t) {
            double length = this.length();
            double offset2 = 0.0;
            double threshold = length * t;
            for (Curve2 c2 : this) {
                double l = c2.end().sub(c2.start()).length();
                Interval i = new Interval(offset2, offset2 + l);
                if (i.contains(threshold)) {
                    return c2.position(i.normalize(threshold));
                }
                offset2 = i.hi;
            }
            throw new IllegalStateException();
        }

        Arc reverse() {
            Arc result2 = new Arc();
            this.forEach(c2 -> result2.addFirst(c2.reverse()));
            return result2;
        }

        IList<Vec2> vertices() {
            IList result2 = new LinearList().addLast(this.head());
            this.forEach(c2 -> result2.addLast(c2.end()));
            return result2;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

