/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

public class Scalars {
    public static final double MACHINE_EPSILON = Math.ulp(1.0);
    public static final double EPSILON = 1.0E-14;

    public static boolean equals(double a2, double b, double epsilon) {
        return Math.abs(a2 - b) < epsilon;
    }

    public static boolean angleEquals(double t0, double t1, double epsilon) {
        boolean result2;
        if (t1 < t0) {
            double tmp = t1;
            t1 = t0;
            t0 = tmp;
        }
        boolean bl = result2 = t1 - t0 < epsilon;
        if (!result2) {
            result2 = t0 - (t1 -= Math.PI * 2) < epsilon;
        }
        return result2;
    }

    public static double normalize(double a2, double b, double n) {
        return (n - a2) / (b - a2);
    }

    public static double lerp(double a2, double b, double t) {
        return a2 + (b - a2) * t;
    }

    public static boolean inside(double min, double n, double max) {
        return min < n && n < max;
    }

    public static double clamp(double min, double n, double max) {
        if (n <= min) {
            return min;
        }
        if (n >= max) {
            return max;
        }
        return n;
    }

    public static double normalizationFactor(double a2, double b, double c2, double d) {
        double exponent = StrictMath.getExponent(Scalars.max(Scalars.max(a2, b), Scalars.max(c2, d)));
        return exponent < -8.0 || exponent > 8.0 ? Math.pow(2.0, -exponent) : 1.0;
    }

    public static double normalizationFactor(double a2, double b, double c2) {
        double exponent = StrictMath.getExponent(Scalars.max(Scalars.max(a2, b), c2));
        return exponent < -8.0 || exponent > 8.0 ? Math.pow(2.0, -exponent) : 1.0;
    }

    public static double normalizationFactor(double a2, double b) {
        double exponent = StrictMath.getExponent(Scalars.max(a2, b));
        return exponent < -8.0 || exponent > 8.0 ? Math.pow(2.0, -exponent) : 1.0;
    }

    public static double max(double a2, double b) {
        return a2 < b ? b : a2;
    }

    public static double max(double a2, double b, double c2) {
        return Scalars.max(a2, Scalars.max(b, c2));
    }
}

