/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.Vec4;
import io.lacuna.artifex.utils.Hashes;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class Matrix4 {
    public static final Matrix4 IDENTITY = new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    private final double[] elements;

    Matrix4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.elements = new double[]{m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33};
    }

    private Matrix4(double[] elements) {
        this.elements = elements;
    }

    public static Matrix4 from(Vec3 a2, Vec3 b, Vec3 c2) {
        return new Matrix4(a2.x, b.x, c2.x, 0.0, a2.y, b.y, c2.y, 0.0, a2.z, b.z, c2.z, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4 from(Vec4 a2, Vec4 b, Vec4 c2, Vec4 d) {
        return new Matrix4(a2.x, b.x, c2.x, d.x, a2.y, b.y, c2.y, d.y, a2.z, b.z, c2.z, d.z, a2.w, b.w, c2.w, d.w);
    }

    public static Matrix4 translate(double x, double y, double z) {
        return new Matrix4(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4 translate(Vec3 v) {
        return Matrix4.translate(v.x, v.y, v.z);
    }

    public static Matrix4 scale(double x, double y, double z) {
        return new Matrix4(x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4 scale(Vec3 v) {
        return Matrix4.scale(v.x, v.y, v.z);
    }

    public static Matrix4 scale(double k) {
        return Matrix4.scale(k, k, k);
    }

    public static Matrix4 rotateX(double radians) {
        double c2 = Math.cos(radians);
        double s2 = Math.sin(radians);
        return new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, c2, -s2, 0.0, 0.0, s2, c2, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4 rotateY(double radians) {
        double c2 = Math.cos(radians);
        double s2 = Math.sin(radians);
        return new Matrix4(c2, 0.0, s2, 0.0, 0.0, 1.0, 0.0, 0.0, -s2, 0.0, c2, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4 rotateZ(double radians) {
        double c2 = Math.cos(radians);
        double s2 = Math.sin(radians);
        return new Matrix4(c2, -s2, 0.0, 0.0, s2, c2, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4 mul(Matrix4 ... matrices) {
        Matrix4 m = matrices[0];
        for (int i = 1; i < matrices.length; ++i) {
            m = m.mul(matrices[i]);
        }
        return m;
    }

    public Matrix4 mul(double k) {
        double[] es = new double[16];
        for (int i = 0; i < 16; ++i) {
            es[i] = this.elements[i] * k;
        }
        return new Matrix4(es);
    }

    public double get(int row, int column) {
        return this.elements[(row << 2) + column];
    }

    public Vec4 row(int row) {
        int idx = row << 2;
        return Vec.vec(this.elements[idx], this.elements[idx + 1], this.elements[idx + 2], this.elements[idx + 3]);
    }

    public Vec4 column(int column) {
        int idx = column;
        return Vec.vec(this.elements[idx], this.elements[idx + 4], this.elements[idx + 8], this.elements[idx + 12]);
    }

    public Matrix4 mul(Matrix4 b) {
        double[] es = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double n = 0.0;
                for (int k = 0; k < 4; ++k) {
                    n += b.get(k, j) * this.get(i, k);
                }
                es[(i << 2) + j] = n;
            }
        }
        return new Matrix4(es);
    }

    public Matrix4 add(Matrix4 b) {
        double[] es = new double[16];
        for (int i = 0; i < 16; ++i) {
            es[i] = this.elements[i] + b.elements[i];
        }
        return new Matrix4(es);
    }

    public Matrix4 transpose() {
        return new Matrix4(this.elements[0], this.elements[4], this.elements[8], this.elements[12], this.elements[1], this.elements[5], this.elements[9], this.elements[13], this.elements[2], this.elements[6], this.elements[10], this.elements[14], this.elements[3], this.elements[7], this.elements[11], this.elements[15]);
    }

    public Vec3 transform(Vec3 v) {
        return new Vec3(v.x * this.elements[0] + v.y * this.elements[1] + v.z * this.elements[2] + this.elements[3], v.x * this.elements[4] + v.y * this.elements[5] + v.z * this.elements[6] + this.elements[7], v.x * this.elements[8] + v.y * this.elements[9] + v.z * this.elements[10] + this.elements[11]);
    }

    public PrimitiveIterator.OfDouble rowMajor() {
        return new PrimitiveIterator.OfDouble(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < 16;
            }

            @Override
            public double nextDouble() {
                if (this.idx < 16) {
                    return Matrix4.this.elements[this.idx++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public PrimitiveIterator.OfDouble columnMajor() {
        return this.transpose().rowMajor();
    }

    public int hashCode() {
        int hash = 0;
        for (double n : this.elements) {
            hash = hash * 31 + Hashes.hash(n);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Matrix4) {
            Matrix4 m = (Matrix4)obj;
            return Arrays.equals(this.elements, m.elements);
        }
        return false;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        this.rowMajor().forEachRemaining(n -> s2.append(n).append(", "));
        return s2.toString();
    }
}

