/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.FloatList;
import processing.data.JSONArray;
import processing.data.JSONObject;
import processing.data.XML;

public class Processing_02_3D
extends PApplet {
    Moonlander moonlander;
    float SPHERE_DIAMETER = 5.0f;
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int PARTICLE_COUNT = 350;
    float MIN_Y = -70.0f;
    float MAX_Y = 70.0f;
    PVector[] particlePositions = new PVector[this.PARTICLE_COUNT * 2];
    PImage backgroundImg;
    JSONObject sevenSeg;
    int rotCount = 0;

    public void settings() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
    }

    public void setup() {
        this.rectMode(3);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"soundtrack.mp3", (int)60, (int)1);
        this.moonlander.start();
        this.setParticlePositions(1, 2);
        this.sevenSeg = this.loadJSONObject("7seg.json");
    }

    public void setParticlePositions(int img1, int img2) {
        FloatList crossingX;
        XML file1 = this.loadXML("drawing" + Processing_02_3D.str((int)img1) + ".svg");
        XML file2 = this.loadXML("drawing" + Processing_02_3D.str((int)img2) + ".svg");
        ArrayList<PVector> lineStartPoints1 = new ArrayList<PVector>();
        ArrayList<PVector> lineEndPoints1 = new ArrayList<PVector>();
        ArrayList<PVector> lineStartPoints2 = new ArrayList<PVector>();
        ArrayList<PVector> lineEndPoints2 = new ArrayList<PVector>();
        this.parsePointsFromXML(file1, lineStartPoints1, lineEndPoints1);
        this.parsePointsFromXML(file2, lineStartPoints2, lineEndPoints2);
        PVector[] positions1 = this.particlePositionsForSegments(lineStartPoints1, lineEndPoints1);
        PVector[] positions2 = this.particlePositionsForSegments(lineStartPoints2, lineEndPoints2);
        int i = 0;
        while (i < positions1.length) {
            PVector pos1 = positions1[i];
            crossingX = this.getCrossingX(pos1.y, lineStartPoints2, lineEndPoints2);
            this.particlePositions[i] = new PVector(pos1.x, pos1.y, crossingX.get(0));
            ++i;
        }
        i = 0;
        while (i < positions2.length) {
            PVector pos2 = positions2[i];
            crossingX = this.getCrossingX(pos2.y, lineStartPoints1, lineEndPoints1);
            this.particlePositions[this.PARTICLE_COUNT + i] = new PVector(crossingX.get(0), pos2.y, pos2.x);
            ++i;
        }
    }

    public PVector[] particlePositionsForSegments(ArrayList<PVector> lineStartPoints, ArrayList<PVector> lineEndPoints) {
        PVector[] retArr = new PVector[this.PARTICLE_COUNT];
        int particlePositionStepper = 0;
        float totalLength = 0.0f;
        int i = 0;
        while (i < lineStartPoints.size()) {
            totalLength += PVector.dist((PVector)lineStartPoints.get(i), (PVector)lineEndPoints.get(i));
            ++i;
        }
        float stepSize = totalLength / (float)(this.PARTICLE_COUNT - 1);
        float r = 0.0f;
        int i2 = 0;
        while (i2 < lineStartPoints.size()) {
            float l = PVector.dist((PVector)lineEndPoints.get(i2), (PVector)lineStartPoints.get(i2));
            int k = Processing_02_3D.floor((float)((l - r) / stepSize));
            int k_i = 0;
            while (k_i <= k) {
                PVector p;
                PVector direction = PVector.sub((PVector)lineEndPoints.get(i2), (PVector)lineStartPoints.get(i2)).normalize();
                retArr[particlePositionStepper] = p = PVector.add((PVector)PVector.add((PVector)lineStartPoints.get(i2), (PVector)PVector.mult((PVector)direction, (float)r)), (PVector)PVector.mult((PVector)direction, (float)((float)k_i * stepSize)));
                ++particlePositionStepper;
                ++k_i;
            }
            r = r + (float)k * stepSize + stepSize - l;
            ++i2;
        }
        while (particlePositionStepper < this.PARTICLE_COUNT) {
            retArr[particlePositionStepper] = retArr[particlePositionStepper - 1];
            ++particlePositionStepper;
        }
        return retArr;
    }

    public void parsePointsFromXML(XML file, ArrayList<PVector> lineStartPoints, ArrayList<PVector> lineEndPoints) {
        float minY = 1000000.0f;
        float maxY = -1000000.0f;
        float minX = 1000000.0f;
        float maxX = -1000000.0f;
        ArrayList<PVector> allPoints = new ArrayList<PVector>();
        XML potentialG = file.getChild("g");
        XML[] paths = potentialG == null ? file.getChildren("path") : potentialG.getChildren("path");
        int i = 0;
        while (i < paths.length) {
            XML path = paths[i];
            String pathStr = path.getString("d");
            String[] pathElements = Processing_02_3D.split((String)pathStr, (String)"L");
            PVector previousPoint = null;
            int j = 0;
            while (j < pathElements.length) {
                String[] pointCoords;
                String pathElem = pathElements[j];
                if (pathElem.charAt(0) == 'M') {
                    pathElem = pathElem.substring(1);
                }
                if ((pointCoords = Processing_02_3D.split((String)pathElem, (String)" ")).length == 2) {
                    PVector newPoint = new PVector(PApplet.parseFloat((String)pointCoords[0]), PApplet.parseFloat((String)pointCoords[1]));
                    if (previousPoint != null) {
                        lineEndPoints.add(newPoint);
                    }
                    lineStartPoints.add(newPoint);
                    allPoints.add(newPoint);
                    previousPoint = newPoint;
                    minY = Processing_02_3D.min((float)minY, (float)newPoint.y);
                    maxY = Processing_02_3D.max((float)maxY, (float)newPoint.y);
                    minX = Processing_02_3D.min((float)minX, (float)newPoint.x);
                    maxX = Processing_02_3D.max((float)maxX, (float)newPoint.x);
                }
                ++j;
            }
            lineStartPoints.remove(lineStartPoints.size() - 1);
            ++i;
        }
        float xOffset = (maxX + minX) / 2.0f;
        float yScalar = (this.MAX_Y - this.MIN_Y) / (maxY - minY);
        for (PVector v : allPoints) {
            v.y = this.MIN_Y + (this.MAX_Y - this.MIN_Y) * (v.y - minY) / (maxY - minY);
            v.x -= xOffset;
            v.x *= yScalar;
        }
    }

    public FloatList getCrossingX(float y, ArrayList<PVector> segmentStartPoints, ArrayList<PVector> segmentEndPoints) {
        FloatList crossingX = new FloatList();
        int i = 0;
        while (i < segmentStartPoints.size()) {
            float x1 = segmentStartPoints.get((int)i).x;
            float y1 = segmentStartPoints.get((int)i).y;
            float x2 = segmentEndPoints.get((int)i).x;
            float y2 = segmentEndPoints.get((int)i).y;
            float epsilon = 0.01f;
            if (y > y1 - epsilon && y < y2 + epsilon || y < y1 + epsilon && y > y2 - epsilon) {
                float x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
                crossingX.append(x);
            }
            ++i;
        }
        crossingX.shuffle();
        return crossingX;
    }

    public void draw() {
        this.moonlander.update();
        this.ortho();
        this.background(0);
        float rockValue = (float)this.moonlander.getValue("rock");
        this.ambientLight(255.0f, 255.0f, 255.0f);
        this.translate(this.width / 2, this.height / 2, 0.0f);
        float pingPongRock = rockValue % 2.0f;
        if (Processing_02_3D.floor((float)(rockValue / 2.0f % 2.0f)) == 1) {
            pingPongRock = 2.0f - pingPongRock;
        }
        this.rotateY(pingPongRock / 4.0f * (float)Math.PI);
        float r = Processing_02_3D.map((float)pingPongRock, (float)0.0f, (float)2.0f, (float)255.0f, (float)0.0f);
        float g = Processing_02_3D.map((float)pingPongRock, (float)0.0f, (float)2.0f, (float)0.0f, (float)255.0f);
        this.fill(r, g, 128.0f);
        int newRotCount = Processing_02_3D.floor((float)(rockValue / 2.0f));
        if (newRotCount > this.rotCount) {
            this.setParticlePositions(newRotCount + 1 + newRotCount % 2, newRotCount + 1 + (newRotCount - 1) % 2);
            this.rotCount = newRotCount;
        }
        if (this.rotCount < 16) {
            int i = 0;
            while (i < this.PARTICLE_COUNT * 2 - 1) {
                PVector pos = this.particlePositions[i];
                this.drawSphere(pos);
                ++i;
            }
        }
        this.translate(-400.0f, -200.0f, -400.0f);
        if (this.rotCount > 15) {
            String[] story = new String[]{"leevi the storymaster", "antti the plotter", "viking the ball painter", "anna the runaway", "l a v a"};
            int i = 0;
            while (i < 5) {
                this.pushMatrix();
                this.writeSentence(story[i]);
                this.popMatrix();
                this.translate(0.0f, 100.0f, 0.0f);
                ++i;
            }
        }
    }

    public void weHaveBalls() {
        this.pushMatrix();
        this.noFill();
        this.stroke(255);
        this.box(100.0f, 100.0f, 300.0f);
        this.popMatrix();
        this.translate(0.0f, 100.0f, 0.0f);
        this.noStroke();
        this.fill(255.0f, 255.0f, 0.0f);
        this.pushMatrix();
        this.threeDeeLetter("w");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("e");
        this.popMatrix();
        this.translate(120.0f, 0.0f, 120.0f);
        this.pushMatrix();
        this.threeDeeLetter("h");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("a");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("v");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("e");
        this.popMatrix();
        this.translate(120.0f, 0.0f, 120.0f);
        this.pushMatrix();
        this.threeDeeLetter("b");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("a");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("l");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("l");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("s");
        this.popMatrix();
    }

    public void vedranCheckTicks(float r, float g) {
        this.pushMatrix();
        this.threeDeeLetter("g");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("d");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("p");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetter("r");
        this.popMatrix();
        this.translate(60.0f, 0.0f, 60.0f);
        this.pushMatrix();
        this.threeDeeLetterSideways("p");
        this.popMatrix();
        this.translate(0.0f, 60.0f, 0.0f);
        this.pushMatrix();
        this.threeDeeLetterSideways("g");
        this.popMatrix();
        this.translate(0.0f, 60.0f, 0.0f);
        this.pushMatrix();
        this.threeDeeLetterSideways("p");
        this.popMatrix();
        this.pushMatrix();
        this.drawCheckTick(false);
        this.popMatrix();
        this.translate(-200.0f, 0.0f, -200.0f);
        this.fill(g, r, 128.0f);
        this.pushMatrix();
        this.drawCheckTick(true);
        this.popMatrix();
        this.translate(-200.0f, 0.0f, -200.0f);
        this.pushMatrix();
        this.fill(r, g, 128.0f);
        this.drawCheckTick(true);
        this.popMatrix();
        this.fill(g, r, 128.0f);
        this.translate(200.0f, 200.0f, 200.0f);
        this.pushMatrix();
        this.drawCheckTick(false);
        this.popMatrix();
        this.translate(-200.0f, 200.0f, -200.0f);
        this.pushMatrix();
        this.drawCheckTick(true);
        this.popMatrix();
        this.fill(r, g, 128.0f);
        this.translate(200.0f, 0.0f, 200.0f);
        this.pushMatrix();
        this.drawCheckTick(false);
        this.popMatrix();
        this.translate(200.0f, 0.0f, 200.0f);
        this.pushMatrix();
        this.drawCheckTick(true);
        this.popMatrix();
    }

    public void drawCheckTick(boolean truth) {
        if (truth) {
            this.drawSphere(0.0f, 0.0f, 14.0f);
            this.drawSphere(12.0f, 0.0f, 14.0f);
            this.drawSphere(1.0f, 1.0f, 13.0f);
            this.drawSphere(11.0f, 1.0f, 13.0f);
            this.drawSphere(2.0f, 2.0f, 12.0f);
            this.drawSphere(10.0f, 2.0f, 12.0f);
            this.drawSphere(3.0f, 3.0f, 11.0f);
            this.drawSphere(9.0f, 3.0f, 11.0f);
            this.drawSphere(4.0f, 4.0f, 10.0f);
            this.drawSphere(8.0f, 4.0f, 10.0f);
            this.drawSphere(5.0f, 5.0f, 9.0f);
            this.drawSphere(7.0f, 5.0f, 9.0f);
            this.drawSphere(6.0f, 6.0f, 8.0f);
            this.drawSphere(6.0f, 6.0f, 8.0f);
            this.drawSphere(7.0f, 7.0f, 7.0f);
            this.drawSphere(5.0f, 7.0f, 7.0f);
            this.drawSphere(8.0f, 8.0f, 6.0f);
            this.drawSphere(4.0f, 8.0f, 6.0f);
            this.drawSphere(9.0f, 9.0f, 5.0f);
            this.drawSphere(3.0f, 9.0f, 5.0f);
            this.drawSphere(10.0f, 10.0f, 4.0f);
            this.drawSphere(2.0f, 10.0f, 0.0f);
            this.drawSphere(11.0f, 11.0f, 3.0f);
            this.drawSphere(1.0f, 11.0f, 1.0f);
            this.drawSphere(12.0f, 12.0f, 2.0f);
            this.drawSphere(0.0f, 12.0f, 2.0f);
        } else {
            this.drawSphere(14.0f, 0.0f, 0.0f);
            this.drawSphere(14.0f, 0.0f, 12.0f);
            this.drawSphere(13.0f, 1.0f, 1.0f);
            this.drawSphere(13.0f, 1.0f, 11.0f);
            this.drawSphere(12.0f, 2.0f, 2.0f);
            this.drawSphere(12.0f, 2.0f, 10.0f);
            this.drawSphere(11.0f, 3.0f, 3.0f);
            this.drawSphere(11.0f, 3.0f, 9.0f);
            this.drawSphere(10.0f, 4.0f, 4.0f);
            this.drawSphere(10.0f, 4.0f, 8.0f);
            this.drawSphere(9.0f, 5.0f, 5.0f);
            this.drawSphere(9.0f, 5.0f, 7.0f);
            this.drawSphere(8.0f, 6.0f, 6.0f);
            this.drawSphere(8.0f, 6.0f, 6.0f);
            this.drawSphere(7.0f, 7.0f, 7.0f);
            this.drawSphere(7.0f, 7.0f, 5.0f);
            this.drawSphere(6.0f, 8.0f, 8.0f);
            this.drawSphere(6.0f, 8.0f, 4.0f);
            this.drawSphere(5.0f, 9.0f, 9.0f);
            this.drawSphere(5.0f, 9.0f, 3.0f);
            this.drawSphere(4.0f, 10.0f, 10.0f);
            this.drawSphere(0.0f, 10.0f, 2.0f);
            this.drawSphere(3.0f, 11.0f, 11.0f);
            this.drawSphere(1.0f, 11.0f, 1.0f);
            this.drawSphere(2.0f, 12.0f, 12.0f);
            this.drawSphere(2.0f, 12.0f, 0.0f);
        }
    }

    public void drawSphere(PVector position) {
        this.drawSphere(position.x, position.y, position.z);
    }

    public void drawSphere(float sphereX, float sphereY, float sphereZ) {
        this.pushMatrix();
        this.lights();
        this.shininess(0.7f);
        float n = this.random(100.0f);
        if (n < 3.0f) {
            this.fill(0.0f, 0.0f, 255.0f);
        }
        if (n > 97.0f) {
            this.fill(255.0f, 255.0f, 0.0f);
        }
        this.emissive(100.0f + this.random(50.0f), 100.0f, 0.0f);
        this.specular(200.0f + this.random(55.0f), 200.0f + this.random(55.0f), 128.0f + this.random(100.0f));
        this.noStroke();
        float sphereDiameter = this.SPHERE_DIAMETER;
        this.translate(sphereX * sphereDiameter, sphereY * sphereDiameter, sphereZ * sphereDiameter);
        this.sphere(sphereDiameter / 2.0f);
        this.popMatrix();
    }

    public JSONArray sevenSegArray(String ch) {
        JSONArray c = this.sevenSeg.getJSONArray(ch);
        return c;
    }

    public void threeDeeLetter(String letter) {
        JSONArray m = this.sevenSegArray(letter);
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 5) {
                String s = m.getString(i);
                if (s.charAt(j) == '1') {
                    this.drawSphere(j, i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void threeDeeLetterSideways(String letter) {
        JSONArray m = this.sevenSegArray(letter);
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 5) {
                String s = m.getString(i);
                if (s.charAt(j) == '1') {
                    this.drawSphere(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
    }

    public void writeSentence(String sentence) {
        int i = 0;
        while (i < sentence.length()) {
            this.translate(this.SPHERE_DIAMETER * 5.2f, 0.0f, this.SPHERE_DIAMETER * 5.2f);
            if (sentence.charAt(i) != ' ') {
                char x;
                this.pushMatrix();
                char[] n = new char[]{' '};
                n[0] = x = sentence.charAt(i);
                String s = new String(n);
                this.threeDeeLetter(s);
                this.popMatrix();
            }
            ++i;
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--stop-color=#cccccc", "Processing_02_3D"};
        if (passedArgs != null) {
            PApplet.main((String[])Processing_02_3D.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

