#version 330 core
in vec2 UV;
out vec4 color;

uniform sampler2D fromtex;
uniform sampler2D inputtex;
uniform int mode;
uniform float itime;
uniform float fa;
uniform float multiplier;
uniform float bufferw;

uniform float macroSize;
const float ar = 16.0/9.0;

vec2 hash( vec2 p ) {             // rand in [-1,1]
    p = vec2( dot(p,vec2(127.1,311.7)),
                dot(p,vec2(269.5,183.3)) );
    return -1. + 2.*fract(sin(p+20.)*53758.5453123);
}

float noise( in vec2 p ) {
        vec2 i = floor(p), f = fract(p);
        vec2 u = f*f*(3.-2.*f);
        return mix( mix( dot( hash( i + vec2(0.,0.) ), f - vec2(0.,0.) ), 
                                         dot( hash( i + vec2(1.,0.) ), f - vec2(1.,0.) ), u.x),
                                mix( dot( hash( i + vec2(0.,1.) ), f - vec2(0.,1.) ), 
                                         dot( hash( i + vec2(1.,1.) ), f - vec2(1.,1.) ), u.x), u.y);
}

vec2 gradient(vec2 loc, int mode) {
    float d = 0.01;
    vec2 base = 2.0 * loc + 0.3*vec2(itime, 2.0 * itime);
    if (mode == 1) {
        base = 4.0 * loc + 0.3*vec2(itime, 2.0 * itime);
    }

    float dx = (noise(base + vec2(d, 0.0)) - noise(base - vec2(d, 0.0))) / (2.0 * d);
    float dy = (noise(base + vec2(0.0, d)) - noise(base - vec2(0.0, d))) / (2.0 * d);

    if (mode == 1) {
        return vec2(dx, dy);
    }
    return round(10.0*vec2(dy, -dx))/10.0; // curl
}

vec2 originCentric(vec2 uv) {
    return -1.0+2.0*uv;
}

vec2 originPositive(vec2 uv) {
    return 0.5+0.5*uv;
}

vec2 transform2(vec2  uv) {
    //float rotation = 0.003*sin(0.1666*itime)-0.00125*cos(0.28*itime);
    //uv *= rot2d(rotation);
    return uv-0.004*vec2(noise(vec2(uv.x*64.0*macroSize, 3.59*itime)), ar*noise(vec2(uv.y*64.0*macroSize, -2.71*itime)));
}

vec2 transform(vec2 uv) {
    return uv-0.002*vec2(noise(vec2(uv.x*ar*4.0, 0.29*itime)), noise(vec2(uv.y*4.0, -0.41*itime)));
}

vec4 sharpen(sampler2D frame, vec2 coords){
    float kernel[9];
    vec2 offset[9];
    float w = bufferw;
    float h = w/ar;
    float step_w = 1.0/w;
    float step_h = 1.0/h;
    offset[0] = vec2(-step_w, -step_h);
    offset[1] = vec2(0.0, -step_h);
    offset[2] = vec2(step_w, -step_h);
    offset[3] = vec2(-step_w, 0.0);
    offset[4] = vec2(0.0, 0.0);
    offset[5] = vec2(step_w, 0.0);
    offset[6] = vec2(-step_w, step_h);
    offset[7] = vec2(0.0, step_h);
    offset[8] = vec2(step_w, step_h);
    kernel[0] = 0.;
    kernel[1] = -1.;
    kernel[2] = 0.;
    kernel[3] = -1.;
    kernel[4] = 5.;
    kernel[5] = -1.;
    kernel[6] = 0.;
    kernel[7] = -1.;
    kernel[8] = 0.;
    vec4 sum = vec4(0.0);
    for (int i = 0; i < 9; i++) {
        vec4 color = texture(frame, transform2(coords)+offset[i]);
        sum += color * kernel[i];
    }
    return sum;
}

vec4 fakevideo() {
    vec4 color = vec4(0.0);
    color = (0.8+0.2*(1.0-fa))*texture(inputtex, UV) + fa*0.2*texture(fromtex, transform(UV)) + fa*0.4*sharpen(fromtex, UV);
    return color*(1.1 - 0.333*smoothstep(0.0, 1.0, fa) + 0.333*smoothstep(0.0, -1.0, fa));
}

void main() {
    if(mode < 1){
        vec4 blurvalue = vec4(0.0);
        vec2 uv = UV;
        float sum = 0.0;
        vec2 d = gradient(uv, mode);
        uv = originCentric(uv);
        for (int i = 0; i < 32; i++) {
            vec4 val = texture(inputtex, clamp(originPositive(uv), 0.0, 1.0));
            float brightness = 1.0 - dot(vec3(1.0 / 3.0), val.rgb);
            blurvalue += brightness * val / 32.0;
            sum += brightness / 32.0;
            if (mode == 1) {
                uv += 0.001 * normalize(d); // foo
            } else {
                uv += 5.0*vec2(2.0/bufferw, 1.0/bufferw) + 0.01*(d);
            }
            uv *= multiplier;
        }
        color = fa * (0.9 * texture(fromtex, UV) + 0.2 * blurvalue / sum) + (1.0 - fa) * texture(inputtex, UV);
    } else {
        color = fakevideo();
    }
}
