; blöömerang
; a 128 byte intrö
; by gasman öf hööy prögram

plot	equ 0x22e5

CALC_DELETE		equ 0x02
CALC_MULTIPLY	equ 0x04
CALC_ADDITION	equ 0x0f
CALC_SIN		equ 0x1f
CALC_INT		equ 0x27
CALC_DUPLICATE	equ 0x31
CALC_CONST		equ 0x34
CALC_STK_ZERO	equ 0xa0
CALC_STK_TEN	equ 0xa4
CALC_ST_MEM_0	equ 0xc0
CALC_END_CALC	equ	0x38

	org 0xc000

	ld c,0xfd
	xor a
	out (254),a
	ld d,62
ay_lp
	ld b,c ; bc=0xfffd to select ay register. But it doesn't check the low bits of B, so 0xfdfd will do
	out (c),a
	ld b,0xbf
	out (c),d
	inc a
	; cp 14 ; loop boundary checks are for lamers
	jr nz,ay_lp
sine	equ 0x8000

; Generate a sine table
	rst 0x28
	db CALC_STK_ZERO
	db CALC_END_CALC

	ld h,0x83
sinelp
	push hl

	rst 0x28
	db CALC_CONST, 0x2b, 0x49 ;const pi/128 (ish)
	db CALC_ADDITION
	db CALC_DUPLICATE
	db CALC_SIN
	db CALC_STK_TEN ; amplitude
	db CALC_MULTIPLY
	db CALC_INT
	db CALC_ST_MEM_0
	db CALC_DELETE
	db CALC_END_CALC
	ld a,(iy+0x5a)			; third byte of calculator memory 0
	add a,11
	pop hl
	ld (hl),a
	dec hl
	bit 7,h; has h reached 0x7f?
	jr nz,sinelp

;	di ; might be useful to stop interrupt routine fiddling with iy. Might not be necessary

	ld ixh,0x81
	ld iyh,0x81
framelp
	; vertical positions
	ld h,(ix+192)
	ld d,(iy+64)
	call adjust_coords

	; horizontal positions
	ld h,(iy+128)

; to go full width (with some ugly wrapping):
;	ld a,(iy+128)
;	add a,a
;	ld h,a

	ld d,(ix)
	call adjust_coords

	ld b,16
drawlp
	ld a,h
	add hl,de
	exx
	ld c,h
	ld b,a
	add hl,de
	push hl
	push de
	call plot
	pop de
	pop hl
	exx
	djnz drawlp

	ld b,0x04
	ld h,0x57
fadelp
	dec (hl)
	jr nz,nounfade
	inc (hl)
nounfade
	cpi
	jp pe,fadelp

	inc ixl
	inc ixl
	inc iyl
	inc iyl
	inc iyl
	jr framelp

; Convert character-based start and end coords into pixel coordinates
; suitable for our plot routine.
; enter with d = initial coord, h = final coord
; return with hl = initial pixel coord as 8.8 fixpoint, de = step value as 8.8 fixpoint
; (assuming 16 steps)
; oh, actually it returns those in alternate registers. yay micro-optimisation
adjust_coords
	sbc hl,de	; hl = x diff
	sra h
	rr l
	; hl = x step (16 steps)
	ex de,hl
	add hl,hl
	add hl,hl
	add hl,hl
	exx

	ret