procedure FillWord(var Dest; Count: Word; Data: Word);
begin
  inline(
    $C4/$7E/<Dest/    (* LES   DI,Dest[BP] *)
    $8B/$4E/<Count/   (* MOV   CX,Count[BP]*)
    $8B/$46/<Data/    (* MOV   AX,Data[BP] *)
    $FC/              (* CLD               *)
    $F3/$AB);         (* REP   STOSW       *)
end;

var
  PalCoeff: TFloat;

procedure MakePlasma(Screen: PRaw);
  const
    Max = 63;

  procedure adjust(xa,ya,x,y,xb,yb: integer);
  var
    d, v: integer;
  begin
    if Screen^[y,x] <> 0 then exit;
    d:=Abs(xa-xb)+Abs(ya-yb);
    v:=Trunc((Word(Screen^[ya,xa])+Word(Screen^[yb,xb])) shr 1 +(random-0.5)*d*PalCoeff);
    if v<1 then v:=1 else if v>Max then v:=Max;
    Screen^[y,x] := v;
  end;

  procedure subDivide(x1,y1,x2,y2: integer);
    var
      x,y: integer;
  begin
    if (x2-x1<2) and (y2-y1<2) then exit;

    x:=(x1+x2) shr 1;
    y:=(y1+y2) shr 1;

    adjust(x1,y1,x,y1,x2,y1);
    adjust(x2,y1,x2,y,x2,y2);
    adjust(x1,y2,x,y2,x2,y2);
    adjust(x1,y1,x1,y,x1,y2);

    if Screen^[y,x] = 0 then
      Screen^[y,x] := (Word(Screen^[y1,x1]) + Word(Screen^[y1,x2]) +
                       Word(Screen^[y2,x2]) + Word(Screen^[y2,x1])) shr 2;

    subDivide(x1,y1,x,y);
    subDivide(x,y1,x2,y);
    subDivide(x,y,x2,y2);
    subDivide(x1,y,x,y2);
  end;

begin
  PalCoeff := Exp(Random*3-2);
  FillWord(Screen^, SizeOf(TRaw), 0);
  Screen^[000, 000] := 1 + Random(Max);
  Screen^[000, 319] := 1 + Random(Max);
  Screen^[199, 000] := 1 + Random(Max);
  Screen^[199, 319] := 1 + Random(Max);
  subDivide(0,0,319,199);
end;

