
#ifndef _CPARTICLE
#define _CPARTICLE

#include "surface.h"
#include "vector.h"

class CParticle
{
	public:

		//constructor & destructor
		CParticle();
		~CParticle();

		void SetPosition(float x,float y,float z);
		void SetVelocity(float x,float y,float z);
		void SetForce(float x,float y,float z);
		void SetMass(float mass);

		float GetX() { return Position.X; }
		float GetY() { return Position.Y; }
		float GetZ() { return Position.Z; }
		float GetMass() { return Mass; }

		void Rotate(float xang,float yang,float zang);

		void GravityAttract(float x,float y,float z,float mass);
		void GravityRepel(float x,float y,float z,float mass);

		void Update(float time);
		void Wrap(float scale);
		void Wrap(float scalex,float scaley,float scalez);
		void Wall(float scale,float damping);

		float size;

	protected:
		float LifeSpan;
		float  Mass;
		CVector Position;
		CVector Velocity;
		CVector Force;
		float m_fRot[3];
};

#endif _CPARTICLE




#ifndef _CSTAR
#define _CSTAR

#include "vector.h"

class CStar : public CParticle
{
	public:

		//constructor & destructor
		CStar();
		~CStar();

		void Draw();
		void SetColor(float r,float g,float b);

	private:
		float m_fColor[3];
};

#endif _CSTAR


#ifndef _CCLOUD
#define _CCLOUD

#include "vector.h"

class CCloud : public CParticle
{
	public:

		//constructor & destructor
		CCloud();
		~CCloud();

		void Draw();
		void SetColor(float r,float g,float b);

	private:
		float m_fColor[3];
};

#endif _CCLOUD


#ifndef _CATTRACTOR
#define _CATTRACTOR

#include "vector.h"

class cAttractor : public CParticle
{
	public:

		//constructor & destructor
		cAttractor();
		~cAttractor();

		void Draw();
		void SetColor(float r,float g,float b);

	private:
		float m_fColor[3];

};

#endif _CATTRACTOR





#ifndef _CREPELLER
#define _CREPELLER

#include "vector.h"

class cRepeller : public CParticle
{
	public:

		//constructor & destructor
		cRepeller();
		~cRepeller();

		void Draw();
		void SetColor(float r,float g,float b);

	private:
		float m_fColor[3];

};

#endif _CREPELLER