
#define AUDIO_ON
#define WINEXE
//#define ERRORON			//turns verbose error output ON

//LIBS
	#ifdef WINEXE
		#include <windows.h>
	#endif
	#include <math.h>
	#include "include/glut.h"
	#include "include/urarlib.h"

//MYLIBS
	#include "core.h"
	#include "surface.h"
	#include "demopart.h"
	#include "funkfilter.h"
	CSurface				*logoMoojuice;
	CSurface				*logoPresents;
	cFunkFilter				funk;
	cAudio					SNDTRACK;

	cXmasPart1		*part1;
	cXmasPart2		*part2;
	cXmasPart3		*part3;
	cXmasPart4		*part4;
	cXmasPart5		*part5;
	cXmasPart6		*part6;

bool paused;
float t=0.0;

	float f0=0.0;
	float f1=0.0;
	float f2=0.0;
	float f3=0.0;
	float f4=0.0;
	float f5=0.0;
	float y=-0.2;
	float x=0.2;
	float trans0=255.0;

void Draw()
{
	rendering=1;

	if (fmod(frames,10)==0) t=TimeElapsed()*8;
	//printf("%f\n",t);
	if (fmod(frames,10)==0) TimerReset();

	long pos=BASS_ChannelGetPosition(SNDTRACK.marker);

	screenClear(1.0,GL_DEPTH_BUFFER_BIT);


	if ((pos>=0) && (pos<5243248))
	{
		part1->update(t,&SNDTRACK);
		part1->draw();
	}

	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	if ((pos>=3543248) && (pos<3943248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//M
		logoMoojuice[0].BindToUse();
		logoMoojuice[0].draw(-1+x,0+y,0,f0);

		f0+=t/200.0;
		if (f0>=1.0) f0=1.0;
	}

	if ((pos>=3943248) && (pos<4443248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//M
		logoMoojuice[0].BindToUse();
		logoMoojuice[0].draw(-1+x,0+y,0,f0);
		//O
		logoMoojuice[1].BindToUse();
		logoMoojuice[1].draw(-0.72+x,0+y,0,f1);

		f1+=t/150.0;
		if (f1>=1.0) f1=1.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}

	if ((pos>=4443248) && (pos<5243248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//M
		logoMoojuice[0].BindToUse();
		logoMoojuice[0].draw(-1+x,0+y,0,f0);
		//O
		logoMoojuice[1].BindToUse();
		logoMoojuice[1].draw(-0.72+x,0+y,0,f1);
		//O
		logoMoojuice[1].draw(-0.47+x,0+y,0,f2);

		f2+=t/150.0;
		if (f2>=1.0) f2=1.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}



	if ((pos>=5243248) && (pos<5303248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//M
		logoMoojuice[0].BindToUse();
		logoMoojuice[0].draw(-1+x,0+y,0,f0);
		//O
		logoMoojuice[1].BindToUse();
		logoMoojuice[1].draw(-0.72+x,0+y,0,f1);
		//O
		logoMoojuice[1].draw(-0.47+x,0+y,0,f2);
		//JUICE
		logoMoojuice[2].BindToUse();
		logoMoojuice[2].draw(-0.25+x,0+y,0,f3);
		logoMoojuice[3].BindToUse();
		logoMoojuice[3].draw(0.43+x,0+y,0,f3);

		f3+=t/50.0;
		if (f3>=1.0) f3=1.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}

	if ((pos>=5303248) && (pos<6043248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		f0=1; f1=1; f2=1; f3=1;
		//M
		logoMoojuice[0].BindToUse();
		logoMoojuice[0].draw(-1+x,0+y,0,f0);
		//O
		logoMoojuice[1].BindToUse();
		logoMoojuice[1].draw(-0.72+x,0+y,0,f1);
		//O
		logoMoojuice[1].draw(-0.47+x,0+y,0,f2);
		//JUICE
		logoMoojuice[2].BindToUse();
		logoMoojuice[2].draw(-0.25+x,0+y,0,f3);
		logoMoojuice[3].BindToUse();
		logoMoojuice[3].draw(0.43+x,0+y,0,f3);
		//PRODUCTIONS
		logoMoojuice[4].BindToUse();
		logoMoojuice[4].draw(-1+x,-0.35+y,0,f4);
		logoMoojuice[5].BindToUse();
		logoMoojuice[5].draw(-0.2+x,-0.35+y,0,f4);

		f4+=t/50.0;
		if (f4>=1.0) f4=1.0;
		funk.SetGlobalMode(FUNKFILTER_OFF);
	}

	if ((pos>=6043248) && (pos<7153248))
	{

		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//M
		logoMoojuice[0].BindToUse();
		logoMoojuice[0].draw(-1+x,0+y,0,f0);
		//O
		logoMoojuice[1].BindToUse();
		logoMoojuice[1].draw(-0.72+x,0+y,0,f1);
		//O
		logoMoojuice[1].draw(-0.47+x,0+y,0,f2);
		//JUICE
		logoMoojuice[2].BindToUse();
		logoMoojuice[2].draw(-0.25+x,0+y,0,f3);
		logoMoojuice[3].BindToUse();
		logoMoojuice[3].draw(0.43+x,0+y,0,f3);
		//PRODUCTIONS
		logoMoojuice[4].BindToUse();
		logoMoojuice[4].draw(-1+x,-0.35+y,0,f4);
		logoMoojuice[5].BindToUse();
		logoMoojuice[5].draw(-0.2+x,-0.35+y,0,f4);

		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		f0-=t/200.0;
		f1-=t/200.0;
		f2-=t/200.0;
		f3-=t/200.0;
		f4-=t/200.0;
		if (f0<=0.0) f0=0.0;
		if (f1<=0.0) f1=0.0;
		if (f2<=0.0) f2=0.0;
		if (f3<=0.0) f3=0.0;
		if (f4<=0.0) f4=0.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}


	if ((pos>=7153248) && (pos<7593248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//dot
		logoPresents[0].BindToUse();
		logoPresents[0].draw(-0.95+x,0+y,0,f0);
		logoPresents[0].draw(0.35+x,0+y,0,f0);

		f0+=t/150.0;
		if (f0>=1.0) f0=1.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}

	if ((pos>=7593248) && (pos<8093248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//dot
		logoPresents[0].BindToUse();
		logoPresents[0].draw(-0.95+x,0+y,0,f0);
		logoPresents[0].draw(0.35+x,0+y,0,f0);
		//dot
		logoPresents[0].draw(-0.7+x,0+y,0,f1);
		logoPresents[0].draw(0.14+x,0+y,0,f1);

		f1+=t/150.0;
		if (f1>=1.0) f1=1.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}

	if ((pos>=8093248) && (pos<9543248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//dot
		logoPresents[0].BindToUse();
		logoPresents[0].draw(-0.95+x,0+y,0,f0);
		logoPresents[0].draw(0.35+x,0+y,0,f0);
		//dot
		logoPresents[0].draw(-0.7+x,0+y,0,f1);
		logoPresents[0].draw(0.14+x,0+y,0,f1);
		//dot
		logoPresents[0].draw(-0.5+x,0+y,0,f2);
		logoPresents[0].draw(-0.11+x,0+y,0,f2);

		f2+=t/150.0;
		if (f2>=1.0) f2=1.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}


	if ((pos>=8953248) && (pos<9543248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//PRESENTS
		logoPresents[1].BindToUse();
		logoPresents[1].draw(-1+x,0+y,0,f3);
		logoPresents[2].BindToUse();
		logoPresents[2].draw(-0.2+x,0+y,0,f3);

		f3+=t/50.0;
		if (f3>=1.0) f3=1.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}

	if ((pos>=9543248) && (pos<12543248))
	{
		funk.SetGlobalMode(FUNKFILTER_ADDITIVE3);

		//PRESENTS
		logoPresents[1].BindToUse();
		logoPresents[1].draw(-1+x,0+y,0,f3);
		logoPresents[2].BindToUse();
		logoPresents[2].draw(-0.2+x,0+y,0,f3);

		f3-=t/200.0;
		if (f3<=0.0) f3=0.0;

		funk.SetGlobalMode(FUNKFILTER_OFF);
	}

	if ((pos>=18243248) && (pos<20543248))
	{
		part5->update(t,&SNDTRACK);
		part5->draw();
	}

	if ((pos>=0) && (pos<20543248))
	{
		//float lightpos[4];
		//lightpos[0]=0.0+sin(frames*RAD)*2;
		//lightpos[1]=0.0+cos(frames*RAD)*2;
		//lightpos[2]=0.0+sin(frames*RAD/2)*2;
		//lightpos[3]=1.0;

		//float lightambient[4] = { 0.2,0.2,0.2,1.0 };
		//float lightdiffuse[4] = { 1.0,1.0,1.0,1.0 };

		//glLightfv(GL_LIGHT0, GL_POSITION,lightpos);
		//glLightfv(GL_LIGHT0, GL_DIFFUSE, lightdiffuse);	
		//glLightfv(GL_LIGHT0, GL_AMBIENT, lightambient);	
		//glEnable(GL_LIGHTING);
		//glEnable(GL_LIGHT0);
		glDisable(GL_LIGHTING);
		glDisable(GL_LIGHT0);

		if ((pos>5243248) && (pos<18243248))
		{
			part3->update(t,&SNDTRACK);
			part3->draw();
		}

		glEnable(GL_FOG);
			part2->update(t,&SNDTRACK);
			part2->draw();
		glDisable(GL_FOG);
	}

	if ((pos>=16043248) && (pos<18243248))
		{
			part4->update(t,&SNDTRACK);
			part4->draw();
		}
	if ((pos>=16743248) && (pos<20543248))
		{
			part6->update(t,&SNDTRACK);
			part6->draw();
		}

	frames+=1;

	glutSwapBuffers();

	#ifdef AUDIO_ON
	if (frames==3) 
	{
		SNDTRACK.play();
	}
	if (pos>=19543248) exit(0);
	#endif

	rendering=0;
}


void Init_Audio()
{
	HWND win=NULL;
	//init audio
	win=GetForegroundWindow();
	#ifdef AUDIO_ON
		SNDTRACK.init(NULL,44100,AUD_VOLMID,AUD_VOLMID,AUD_VOLMID,0.5,FALSE,FALSE);
		SNDTRACK.stats();
		SNDTRACK.addstream("2001.mp3",0);
	#endif
}


void Init_GL()
{
	//init openGL
	initGL((GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH),640,480,0,0,"2001: a Cow Odysee/moOjUiCE Productions",1);
	initGLTweaks();
	glutReshapeFunc(Reshape);
	glutDisplayFunc(Draw);
	glutKeyboardFunc(Key);
	glutTimerFunc(1,update,0);

	//disable cursor inside window
	glutSetCursor(GLUT_CURSOR_NONE);
}


int __cdecl main(int argc, char *argv[])
{
	frames=0;
	GenSINCOS();
	glutInit(&argc, argv);
	Init_GL();
	Init_Audio();
	printf("Loading...\n");

	glEnable(GL_TEXTURE_2D);

	logoMoojuice = new CSurface[6];
	logoMoojuice[0].LoadTGARAR("m_128x128.tga");
	logoMoojuice[0].Bind(GetFreeTextureIndex());
	logoMoojuice[1].LoadTGARAR("o_128x128.tga");
	logoMoojuice[1].Bind(GetFreeTextureIndex());
	logoMoojuice[2].LoadTGARAR("juic_256x128.tga");
	logoMoojuice[2].Bind(GetFreeTextureIndex());
	logoMoojuice[3].LoadTGARAR("e_64x128.tga");
	logoMoojuice[3].Bind(GetFreeTextureIndex());
	logoMoojuice[4].LoadTGARAR("produ_256x128.tga");
	logoMoojuice[4].Bind(GetFreeTextureIndex());
	logoMoojuice[5].LoadTGARAR("ctions_256x128.tga");
	logoMoojuice[5].Bind(GetFreeTextureIndex());

	logoPresents = new CSurface[3];
	logoPresents[0].LoadTGARAR("dot_64x64.tga");
	logoPresents[0].Bind(GetFreeTextureIndex());
	logoPresents[1].LoadTGARAR("pres_256x64.tga");
	logoPresents[1].Bind(GetFreeTextureIndex());
	logoPresents[2].LoadTGARAR("ents_256x64.tga");
	logoPresents[2].Bind(GetFreeTextureIndex());

	part1 = new cXmasPart1;
	part2 = new cXmasPart2;
	part3 = new cXmasPart3;
	part4 = new cXmasPart4;
	part5 = new cXmasPart5;
	part6 = new cXmasPart6;

	glFogi(GL_FOG_MODE, GL_LINEAR);
	GLfloat fog_color[4] = { 0.0,0.0,0.0,0.0 };
	glFogfv(GL_FOG_COLOR, fog_color);
	glFogf(GL_FOG_DENSITY, 0.95f);						// How Dense Will The Fog Be
	glHint(GL_FOG_HINT, GL_DONT_CARE);					// Fog Hint Value
	glFogf(GL_FOG_START, 50.0f);							// Fog Start Depth
	glFogf(GL_FOG_END, 300.0f);							// Fog End Depth

	glutMainLoop();

	delete part6;
	delete part5;
	delete part4;
	delete part3;
	delete part2;
	delete part1;
	delete [] logoPresents;
	delete [] logoMoojuice;

	return 0;
}


///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////