/* include file for the "UniquE RAR File Lib" */
/* (C) 2000 by Christian Scheurer aka. UniquE */
/* multi-OS version (Win32, Linux and SUN)    */

#ifndef __URARLIB_H
#define __URARLIB_H

#ifdef __cplusplus
extern "C"
{
#endif


/* ************************************************************************ */
/* ************************************************************************ */
/* **                                                                    ** */
/* **   CONFIGURATION of the UniquE RAR FileLib                          ** */
/* **   ==> you may change the setting for the lib HERE!                 ** */
/* **                                                                    ** */
/* ************************************************************************ */
/* ************************************************************************ */


#define _DEBUG_LOG                          /* generate debug messages      */

#define _DO_CRC32_CHECK                     /* perform cyclical redundancy  */
                                            /* check (CRC32) - disable this */
                                            /* for a little speed-up        */

#ifdef WIN32                                /* autodetect Win32 and Linux   */
#define _WIN_32                             /* Win32 with VisualC           */
#define _DEBUG_LOG_FILE "C:\\temp\\debug_unrar.txt" /* log file path        */
#else
#define _UNIX                               /* Linux or Unix with GCC       */
#define _DEBUG_LOG_FILE "/tmp/debug_unrar.txt" /* log file path             */
/*#define NON_INTEL_BYTE_ORDER*/              /* GCC on motorola systems    */
#endif

/* ------------------------------------------------------------------------ */


/* -- global functions ---------------------------------------------------- */

/* urarlib_get:
 * decompresses and decrypt data from a RAR file to a buffer in system memory.
 *
 *   input: *output         pointer to an empty char*. This pointer will show
 *                          to the extracted data
 *          *size           shows where to write the size of the decompressed
 *                          file
 *                          (**NOTE: URARLib _does_ memory allocation etc.!**)
 *          *filename       pointer to string containing the file to decompress
 *          *libfilename    pointer to a string with the full name and path of
 *                          the RAR file
 *          *libpassword    pointer to a string with the password used to 
 *                          en-/decrypt the RAR
 *   output: int            returns TRUE on success or FALSE on error 
 *                          (FALSE=0, TRUE=1)
 */

extern int urarlib_get(void  *output, unsigned long *size, char *filename, char *libfilename, char *libpassword);

/* ------------------------------------------------------------------------ */



#ifdef __cplusplus
};
#endif

#endif

