
#include "demopart.h"

void drawbackground(float scale,float rx,float ry,float rz,float alpha)
{
	boolean light=glIsEnabled(GL_LIGHTING);
	boolean depth=glIsEnabled(GL_DEPTH_TEST);

	glDisable(GL_LIGHTING);
	//glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glMatrixMode (GL_PROJECTION);
	glPushMatrix ();
		//glLoadIdentity ();
		glMatrixMode (GL_MODELVIEW);
		glPushMatrix ();
			glLoadIdentity ();
			//glScalef(sx,sy,1);

			//glTranslatef(0,0,-scale/2);
			//glTranslatef(0,0,sin(ry*3.14/180)*2);
			glTranslatef(0,0,rz+(-scale/2)+(sin(ry*3.14/180)*2));

			glRotatef(cos((rx+scale)*3.14/180)*60/*+(scale*10)*/,1,0,0);
			glRotatef(sin((ry+scale)*3.14/720)*60/*-(scale*10*/,0,1,1);
			//glRotatef(rz,0,0,1);
			glBegin (GL_QUADS);
				glColor4f(1,1,1,alpha);
				glTexCoord2i(0,1);
				glVertex3i (-1, -1, -1);
				glTexCoord2i(1,1);
				glVertex3i (1, -1, -1);
				glTexCoord2i(1,0);
				glVertex3i (1, 1, -1);
				glTexCoord2i(0,0);
				glVertex3i (-1, 1, -1);
			glEnd ();
		glPopMatrix ();
		glMatrixMode (GL_MODELVIEW);
	glPopMatrix ();
	glDisable(GL_TEXTURE_2D);
	if (depth) glEnable(GL_DEPTH_TEST);
	if (light) glEnable(GL_LIGHTING);
}

cXmasPart1::cXmasPart1()
{
	texture.LoadTGARAR("little_cow_128x128.tga");
	texture.Bind(GetFreeTextureIndex());
	rx=0;
	ry=0;
	rz=0;
	rr=1;
}

cXmasPart1::~cXmasPart1()
{
}

cXmasPart1::update(float time,cAudio *audio)
{
	long pos=BASS_ChannelGetPosition(audio->marker);
	if ((pos>543248) && (pos<17243248))
	{
		rr+=time;
	}
	rx+=(time);
	ry+=(time);
}

cXmasPart1::draw()
{
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	texture.BindToUse();

	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE);
		drawbackground(51,rx/10,ry/20,rr/250.0,1);
	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE);
	for (float i=50; i>2; i--)
		drawbackground(i,rx/10,ry/20,rr/250.0,0.1);
	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE);
		drawbackground(1,rx/10,ry/20,rr/250.0,1);

	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);
	funk1.SetGlobalMode(FUNKFILTER_OFF);

}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

cXmasPart2::cXmasPart2()
{
	//srand(1);

	starfield.Init(2000,100,100,200);
	starfield.CreateRepellers(0);
	starfield.CreateAttractors(0);
	starfield.Randomise();
	starfield.SetVelocity(0,0,0.2);
	starfield.SetForce(0,0,0);
	//starfield.SetStarTexture("star_blue_16x16.tga");
	starfield.SetStarTexture("star_orange_16x16.tga");
	//starfield.SetStarTexture("star_yellow.tga");
	starfield.wrap=true;

	//srand(415);

	cloud.Init(100,100,100,200);
	cloud.CreateRepellers(0);
	cloud.CreateAttractors(0);
	cloud.Randomise();
	cloud.SetVelocity(0,0,0.2);
	cloud.SetForce(0,0,0);
	//cloud.SetCloudTexture("star_blue_16x16.tga");
	cloud.SetCloudTexture("star_fun.tga");
	cloud.wrap=true;
	//cloud.SetCloudTexture("star_medium_256x256.tga");

	//srand(193);

	cloud2.Init(100,100,100,200);
	cloud2.CreateRepellers(0);
	cloud2.CreateAttractors(0);
	cloud2.Randomise();
	cloud2.SetVelocity(0,0,0.2);
	cloud2.SetForce(0,0,0);
	//cloud2.SetCloudTexture("star_orange_16x16.tga");
	cloud2.SetCloudTexture("star_red.tga");
	cloud2.wrap=true;

	starfield.Update(0.2);
	cloud.Update(0.2);
	cloud2.Update(0.2);
	
	//plasma.Init(64,64);
	//plasma.SetMode(PLASMA_ALPHA);
	//plasma.Update(1);

	ry=0;
	v=0;
	rotate=false;
	randset=false;
}

cXmasPart2::~cXmasPart2()
{
}

cXmasPart2::setState(int state)
{
	if (state==0)
		rotate=false;
	if (state==1)
		rotate=true;
}

cXmasPart2::update(float time,cAudio *audio)
{
	//starfield.SetRotate(time,time*3,time*2);
	//starfield.SetRotate(0,time*2,time);
	starfield.Update(time/10.0);
	cloud.Update(time/10.0);
	cloud2.Update(time/10.0);
	//starfield.SetScale(10+fabs(50*sin(rx*3.14/180)));
	//plasma.SetTransparency(sin(rx*RAD)*255);
	//plasma.Update(time/50);

	long pos=BASS_ChannelGetPosition(audio->marker);
	if ((pos>10793248) && (pos<11043248))
		{
			starfield.SetVelocity(-0.1,-0.3,0.2);
			cloud.SetVelocity(-0.1,-0.3,0.2);
			cloud2.SetVelocity(-0.1,-.3,0.2);
			starfield.wrap=true;
			cloud.wrap=true;
			cloud2.wrap=true;
	}
	if ((pos>10793248) && (pos<12793248))
	{
			if (ry<180)
				ry+=(time/20.0);
			if (v<0.4)
				v+=(time/100.0);
			starfield.SetRotate(0,ry,0);
			cloud.SetRotate(0,ry,0);
			cloud2.SetRotate(0,ry,0);
			starfield.SetVelocity(0,0,v);
			cloud.SetVelocity(0,0,v);
			cloud2.SetVelocity(0,0,v);
	}
	if ((pos>12793248) && (pos<14793248))
		{
			/*if (randset==false)
			{
				starfield.Randomise();
				cloud.Randomise();
				cloud2.Randomise();
				randset=true;
			}*/
			starfield.SetVelocity(0,0,0.4);
			cloud.SetVelocity(0,0,0.4);
			cloud2.SetVelocity(0,0,0.4);
			starfield.wrap=true;
			cloud.wrap=true;
			cloud2.wrap=true;
		}
	if (pos>16793248)
		{
			/*if (randset==false)
			{
				starfield.Randomise();
				cloud.Randomise();
				cloud2.Randomise();
				randset=true;
			}*/

			starfield.wrap=true;
			cloud.wrap=true;
			cloud2.wrap=true;
		}
}

cXmasPart2::draw()
{
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);


	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE);
	starfield.Draw();
	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE);
	cloud.Draw();
	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE);
	cloud2.Draw();

	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);
	funk1.SetGlobalMode(FUNKFILTER_OFF);
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

cXmasPart3::cXmasPart3()
{
	yy=1;
	animCow.LoadTGARAR("cow1_256x256.tga");
	animCow.Bind(GetFreeTextureIndex());

	plasma.Init(64,64);
	plasma.SetMode(PLASMA_ALPHA);
	plasma.Update(1);
	pf=-255;
	ss=1;
	s=-8;
	cowid=0;
	onBG=false;
	fade2=false;
	fd=0;
}

cXmasPart3::~cXmasPart3()
{
}

cXmasPart3::update(float time,cAudio *audio)
{
	yy-=time/10000.0;
	long pos=BASS_ChannelGetPosition(audio->marker);
	fade=false;
	if (
		((pos>6093248) && (pos<6943248)) ||
	    ((pos>9643248) && (pos<10543248))
	   )
	{
		fade=true;
		pf+=time/4.0;
		if (pf>-110.0) pf=-110.0;
	}
	if (
		((pos>6943248) && (pos<7143248)) ||
		((pos>10543248) && (pos<12043248))
	   )
	{
		fade=true;
		pf-=time/4.0;
		if (pf<-255.0) pf=-255.0;
	}
	if (pos>12443248)
	{
		onBG=true;
		fade=true;
		pf+=time/10.0;
		if (pf>255.0) pf=255.0;
		s+=time/150;
		ss-=time/20000;
		if (ss<0) ss=0;
		if (s>57) s=57;
	}
	if (pos>16343248)
		fade2=true;
	if (fade2)
		fd+=(time/10.0);
	if (fd>1.0) fd=1.0;
	plasma.SetTransparency(pf);
	plasma.Update(time/50);

}

cXmasPart3::draw()
{
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);

	glDepthRange(-100,400);

	glEnable(GL_DEPTH_TEST);

	if (fade)
	{
		funk1.SetGlobalMode(FUNKFILTER_OFF);
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GREATER,0.5);

		glDisable(GL_DEPTH_TEST);
		animCow.BindToUse();
		animCow.draw(0.14*ss,-0.2*ss,-10,0,0,0,64-s,64-s,1);

		glDisable(GL_ALPHA_TEST);
		funk1.SetGlobalMode(FUNKFILTER_ADDITIVE2);
		plasma.Draw();
	}


	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);
	funk1.SetGlobalMode(FUNKFILTER_OFF);
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

cXmasPart4::cXmasPart4()
{
	greetz1.LoadTGARAR("left_xmas_greets_256x256.tga");
	greetz1.Bind(GetFreeTextureIndex());
	greetz2.LoadTGARAR("right_greets_256x256.tga");
	greetz2.Bind(GetFreeTextureIndex());
	gxy=0;
	second=false;
}

cXmasPart4::~cXmasPart4()
{
}

cXmasPart4::update(float time,cAudio *audio)
{
	gxy+=time/50;

	long pos=BASS_ChannelGetPosition(audio->marker);
	if (pos>16343248)
		second=true;
}

cXmasPart4::draw()
{
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);

	funk1.SetGlobalMode(FUNKFILTER_LIGHTEN);
	greetz1.BindToUse();
	greetz1.draw(-0.7,-0.85,0,0,0,0,1,1,1);
	if (second)
	{
		greetz2.BindToUse();
		greetz2.draw(0.10,-0.85,0,0,0,0,1,1,1);
	}

	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);
	funk1.SetGlobalMode(FUNKFILTER_OFF);
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

cXmasPart5::cXmasPart5()
{
	clockimg1.LoadTGARAR("2001bk_left_256x256.tga");
	clockimg1.Bind(GetFreeTextureIndex());
	clockimg2.LoadTGARAR("2001bk_right_256x256.tga");
	clockimg2.Bind(GetFreeTextureIndex());
	timeimg1.LoadTGARAR("2001_left_256x256.tga");
	timeimg1.Bind(GetFreeTextureIndex());
	timeimg2.LoadTGARAR("2001_right_256x256.tga");
	timeimg2.Bind(GetFreeTextureIndex());

	blink=0.0;
	timeon=false;
}

cXmasPart5::~cXmasPart5()
{
}

cXmasPart5::update(float time,cAudio *audio)
{
	blink+=(time/1000.0);
	if (blink>1.0)
	{
		blink=0.0;
		timeon=!timeon;
	}
}

cXmasPart5::draw()
{
	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);

	clockimg1.BindToUse();
	clockimg1.draw(-0.40,0,0);

	clockimg2.BindToUse();
	clockimg2.draw(0.40,0,0);

	if (timeon)
	{
		timeimg1.BindToUse();
		timeimg1.draw(-0.40,0,0);

		timeimg2.BindToUse();
		timeimg2.draw(0.40,0,0);
	}

	funk1.SetGlobalMode(FUNKFILTER_ADDITIVE2);

	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);
	funk1.SetGlobalMode(FUNKFILTER_OFF);
}


///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

cXmasPart6::cXmasPart6()
{
	explosion.Init(0,0,0,"star_blue_16x16.tga","star_blue_16x16.tga");
	explosion2.Init(0,0,0,"star_orange_16x16.tga","star_orange_16x16.tga");
	secondOne=false;
}

cXmasPart6::~cXmasPart6()
{
}

cXmasPart6::update(float time,cAudio *audio)
{
	long pos=BASS_ChannelGetPosition(audio->marker);
	if ((pos>=17043248) && (pos<20543248))
	{
		explosion2.update(time/40);
	}
	if ((pos>=18243248) && (pos<20543248))
	{
		secondOne=true;
		//explosion.update(time/50);
	}
}

cXmasPart6::draw()
{
	//funk1.SetGlobalMode(FUNKFILTER_ADDITIVE2);
	explosion2.Draw();
	//if (secondOne)
	//	explosion.Draw();
	//funk1.SetGlobalMode(FUNKFILTER_OFF);
}



///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
