
#ifndef _CCLOUDS
#define _CCLOUDS

#include "surface.h"
#include "particle.h"


class cClouds
{
	public:

		//constructor & destructor
		cClouds();
		~cClouds();

		//clouds
		void Init(int numclouds,float scale);
		void Init(int numclouds,float scalex,float scaley,float scalez);
		void SetRotate(float rotx,float roty,float rotz);
		void SetVelocity(float x,float y,float z);
		void SetForce(float x,float y,float z);
		void SetScale(float scale) { m_fScaleX=scale; m_fScaleY=scale; m_fScaleZ=scale; }
		void SetCloudTexture(char *filename);
		void Randomise();

		//attractors and repellers
		void CreateAttractors(int num);
		void CreateRepellers(int num);

		void Update(float time);
		void Draw();

		bool wrap;

	private:

		int m_intNumClouds;
		CCloud *m_pCloud;
		int m_intCloudGLIndex;
		CSurface m_pCloudSurface;

		int m_intNumAttractors;
		cAttractor *m_pAttractor;

		int m_intNumRepellers;
		cRepeller *m_pRepeller;

		float m_fScaleX,m_fScaleY,m_fScaleZ;
		float m_fWallDamping;
		float m_fRot[3];

};

#endif _CCLOUDS