#include "rotris.h"

.GLOBAL wavRefresh
.GLOBAL wavUpdate
.GLOBAL wavSetup
.GLOBAL wavStop
.GLOBAL mix_ch
.GLOBAL freqtable
.GLOBAL playSample
.GLOBAL initSamples
.GLOBAL playFX
.GLOBAL smp

wavRefresh:
	@ldr r0,mix_stat
	@tst r0,#1               @ if (mix_stat&1)
	@bxeq lr

	stmfd sp!,{r0-r12,lr}  @ Not necessary, but for some reason the final file gets smaller :)
	ldr r0,=mix
	ldr r1,mix_curbuf
	add r0,r0,r1,lsl #9  @ r0 points to outbuffer
	mov r1,#BUFSIZE
	ldr r2,=mix_ch
	ldr r11,=PLAYFREQ
_mixposloop:
	mov r4,r2 @ r4 = current channel structure
	mov r5,#NO_CHANNELS @ r5 = channel counter	
	mov r12,#0
_mixchloop:
 	@ r6 = vol, r7 = pos, r8 = end, r9 = freq, r10 = cnt
	ldmia r4,{r6-r10}
	cmp r7,#0
	beq _mixnextch
	ldrsb r3,[r7]
	mul r3,r6,r3
	add r12,r12,r3,asr #6
	add r10,r10,r9
_mixrep:	
	str r10,[r4,#MIX_CNT]
	subs r10,r10,r11
	blt _mixnextch
	add r7,r7,#1
	cmp r7,r8
	@blt _updatepos
	@ldr r7,[r4,#MIX_START]
	movge r7,#0 @ Sample looping removed, always set to 0 when sample end is reached
	@mov r10,#0
_updatepos:	
	str r7,[r4,#MIX_POS]
	b _mixrep
_mixnextch:
	add r4,r4,#MIX_SIZEOF
	subs r5,r5,#1
	bne _mixchloop
	cmp r12,#-128
	movlt r12,#-128
	cmp r12,#127
	movgt r12,#127
	strb r12,[r0],#1
	subs r1,r1,#1
	bne _mixposloop	
	
	ldmfd sp!,{r0-r12,lr}
	bx lr

wavUpdate:
	@ldr r0,mix_stat
	@tst r0,#1               @ if (mix_stat&1)
	@bxeq lr
	
	ldr r11,=REG_BASE
	@ldr r1,=0x8440  @ Skip some "Nintendo-says-you-have-to-do-this" code
	@strh r1,[r11,#OFFSET_REG_DMA1CNT_H]  @ *(vu16*)(REG_DMA0CNT_H+(1*12))=0x8440;
	@sub r1,r1,#0x8000
	mov r1,#0x440
	strh r1,[r11,#OFFSET_REG_DMA1CNT_H]  @ *(vu16*)(REG_DMA0CNT_H+(1*12))=0x0440;
	
	ldrh r1,[r11,#OFFSET_REG_SOUNDCNT_X]
	orr r1,r1,#SOUND_DMG_ON
	strh r1,[r11,#OFFSET_REG_SOUNDCNT_X]  @ *(vu16*)REG_SOUNDCNT_X|=SOUND_DMG_ON;
	
	ldrh r1,[r11,#OFFSET_REG_SOUNDCNT_H]
	ldr r0,=0xF0FB
	and r1,r1,r0
	orr r1,r1,#(3<<8)|4
	strh r1,[r11,#OFFSET_REG_SOUNDCNT_H]  @ *(vu16*)REG_SOUNDCNT_H=(*(vu16*)REG_SOUNDCNT_H&0xF0FB) | (3<<8) | 4;

	add r0,r11,#OFFSET_REG_DMA1
	ldr r1,=mix
	
	ldr r5,mix_curbuf
	mov r6,r5,lsl #9  @ Compresses better to split it up (for some reason)
	add r1,r1,r6
	eor r5,r5,#1                     @ mix_curbuf^=1;
	str r5,mix_curbuf
	
	str r1,[r0]
	add r1,r11,#OFFSET_REG_FIFO_A
	str r1,[r0,#4]
	ldr r1,=DMA_ENABLE | DMA_TIMMING_SOUND | DMA_CONTINUOUS_ON  | DMA_SRC_INC | DMA_DEST_FIX | DMA_32BIT_BUS | ((4*4)/(32/8))
	str r1,[r0,#8]	        @ DmaSet(1, mix[mix_curbuf], REG_FIFO_A, ( ----- })
	
	ldr r0,=65536-798+0x800000          @ *(vu16*)REG_TM0CNT_L=65536-Div(CPU_HZ,PLAYFREQ); // 65536-798
	str r0,[r11,#OFFSET_REG_TM0CNT]     @ *(vu16*)REG_TM0CNT_H=0x0080;
	
	bx lr

wavStop:
@	ldr r1,=mix_ch+MIX_POS
@	mov r2,#0
@	mov r3,#24
@	mul r3,r0,r3	
@	cmp r0,#0
@	strge r2,[r1,r3]
@	bge _stopChDone
wavSetup:
	mov r0,#0
	ldr r1,=mix_ch
	dmaclear MIX_SIZEOF*NO_CHANNELS
	mov r0,#1
	str r0,mix_stat
_stopChDone:	
	bx lr

@ r0 = sample
playFX:
	stmfd sp!,{r0-r12,lr}
	ldr r1,=smp
	add r1,r1,r0,lsl #4
	mov r0,#7
	mov r2,#29
	mov r3,#64	
	b playSample+4

@ r0=chno, r1->smp, r2=note, r3=vol

playSample:
	stmfd sp!,{r0-r12,lr}
	
	ldr r4,=mix_ch
	add r4,r4,r0,lsl #5  @ r4=&mix[chno]
	str r3,[r4,#MIX_VOL]  @ mix_ch[chno].vol=vol;	
	ldr r0,[r1,#SMP_OFS]
	str r0,[r4,#MIX_POS]  @ mix_ch[chno].pos=(s8*)p->ofs;	
	ldr r5,[r1,#SMP_LEN]
	@and r5,r5,#0xFFFFFFFC  @ Not necessary if sample length is divisible by 4
	add r5,r0,r5
	str r5,[r4,#MIX_END] @ mix_ch[chno].end=(s8*)p->ofs+(p->len&~3);
	@ldr r5,[r1,#SMP_LOOP] @ Feature removed
	@cmp r5,#0
	@moveq r0,#0
	@str r0,[r4,#MIX_START] @ mix_ch[chno].start=p->loop?(s8*)p->ofs:0;
	mov r0,#0
	str r0,[r4,#MIX_CNT]  @ mix_ch[chno].cnt=0;
	ldr r0,=freqtable
	@add r2,r2,#36
	ldr r0,[r0,r2,lsl #2]
	str r0,[r4,#MIX_FREQ]  @ mix_ch[chno].freq=freqtable[note+36];

	ldmfd sp!,{r0-r12,lr}
	bx lr

initSamples:
	stmfd sp!,{r0-r12,lr}
	@ Build freqtable
	ldr r0,=freqtable
	adr r1,freqtabledef
	mov r2,#12
_buildFreqLoop1:
	ldrh r4,[r1],#2
	mov r3,#2*12 @mov r3,#5*12
_buildFreqLoop2:	
	str r4,[r0,r3,lsl #2]
	mov r4,r4,lsr #1
	subs r3,r3,#12
	bcs _buildFreqLoop2
	subs r2,r2,#1
	add r0,r0,#4
	bne _buildFreqLoop1
		
	adr r1,smpData
	mov r2,#EX_WRAM
	ldr r3,=smp
	mov r5,#17
_smpLoop:
	mov r0,r2
	bl genSample
	str r0,[r3,#SMP_LEN]
	str r2,[r3,#SMP_OFS]
	add r2,r2,r0
	@ldrb r4,[r1,#SI_SIZEOF-1]  @ Feature removed
	@and r4,r4,#8
	@str r4,[r3,#SMP_LOOP]
	add r1,r1,#SI_SIZEOF
	add r3,r3,#SMP_SIZEOF
	subs r5,r5,#1	
	bne _smpLoop
	
	ldmfd sp!,{r0-r12,lr}
	bx lr

freqtabledef:
	.hword 19516,20676,21905,23208,24588,26050,27599,29240,30979,32821,34773,36840

@ 14 bytes per sample. Make sure sample length (sustain+release) is divisible by 4!
smpData:
@        freq,pitch,ampl, sust, rele, cut,res, cenv, renv&type|f|l
	.hword  472,W(  0, 40),  244, 6420,W(20, 1),  512,W( 0,G_SQU|4  )   @ Melody 1
	.hword  472,W(  0, 40),  490, 2334,W(15, 1), 1024,W(15,G_SAW|4  )   @ Melody 2
	.hword  118,W(  0, 31),  610, 5834,W( 6, 1),    0,W( 8,G_SAW|4  )   @ Bass
	.hword  156,W(200, 35),  610, 1166,W( 3, 1),    0,W( 0,G_SQU    )   @ Bass drum
	.hword  539,W(  0, 60),  120,  292,W(30,10),    0,W( 0,G_NOI|4  )   @ Hihat
	.hword 1000,W(  0, 60), 2340, 3500,W(30, 1),    0,W( 0,G_NOI|4  )   @ Snare
	@.hword  472,W(  0, 20),11668,    0,W(20, 1), 1024,W( 0,G_SQU|4|8)   @ String
	.hword  472,W(  0, 20),20000,    0,W(20, 1), 1024,W( 0,G_SQU|4  )   @ String

	.hword  472,W(  0, 40),   52, 2000,W( 0, 0),    0,W( 0,G_SQU    )   @ Sharp melody
	.hword  472,W(  0, 25),  500, 6000,W(10, 1), 4096,W( 0,G_SAW|4  )   @ Soft string
	.hword  236,W(  0, 30),  400, 2000,W(15, 1), 1024,W(15,G_SAW|4  )   @ Bass
	.hword  472,W(  0, 30),  400, 2000,W(15, 1), 1024,W(15,G_SAW|4  )   @ Bass
	
	.hword  260,W( 12,135), 1166, 1750,W( 2, 1),19968,W(15,G_NOI|4  )   @ FX rotate
	.hword  260,W( 25,150), 1166, 1750,W( 2, 1), 4096,W(10,G_NOI|4  )   @ FX move
	.hword  338,W(200, 60), 1750, 3098,W( 2, 1), 1024,W(15,G_SAW|4  )   @ FX drop
	.hword  338,W( 56, 60), 1166, 2450,W( 5, 1), 2048,W( 2,G_SQU|4  )   @ FX clear lines
	.hword  300,W( 95, 60), 1166, 3550,W( 5, 1), 2048,W( 2,G_SQU|4  )   @ FX tetris
	.hword  200,W(253, 60), 6000,16000,W( 5, 1), 2048,W( 2,G_SAW|4  )   @ FX game over

.align

	.LTORG

mix_curbuf: .word 0
mix_stat:   .word 0

	.BSS
	
mix_ch:
	.space MIX_SIZEOF*NO_CHANNELS
	
mix:
	.space 1024

freqtable:
	.space 4*84

smp:
	.space 16*32

	.END
